/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;

public class Leading
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        XPathContextMajor c2 = context.newCleanContext();
        FunctionItem function = arguments.length == 2 ? (FunctionItem)arguments[1].head() : context.getConfiguration().makeSystemFunction("data", 1, 31);
        return SequenceTool.toLazySequence(new LeadingIterator(arguments[0].iterate(), function, c2));
    }

    private static class LeadingIterator
    implements SequenceIterator {
        private final SequenceIterator base;
        private final FunctionItem function;
        private final XPathContext context;
        private boolean exhausted = false;
        private final Sequence[] args = new Sequence[1];

        public LeadingIterator(SequenceIterator base, FunctionItem function, XPathContext context) {
            this.base = base;
            this.function = function;
            this.context = context;
        }

        @Override
        public Item next() {
            if (this.exhausted) {
                return null;
            }
            Item next = this.base.next();
            if (next == null) {
                return null;
            }
            this.args[0] = next;
            try {
                boolean matches = ExpressionTool.effectiveBooleanValue(SystemFunction.dynamicCall(this.function, this.context, this.args).iterate());
                if (matches) {
                    return next;
                }
                this.exhausted = true;
                this.base.close();
                return null;
            }
            catch (XPathException e) {
                throw new UncheckedXPathException(e);
            }
        }

        @Override
        public void close() {
            this.base.close();
        }
    }
}

