/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.ids_mannheim.korap.util.KrillString;
import java.util.LinkedList;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Message
implements Cloneable {
    ObjectMapper mapper = new ObjectMapper();
    private String msg;
    private int code = 0;
    private LinkedList<String> parameters;

    public Message(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Message() {
    }

    @JsonIgnore
    public String getMessage() {
        return this.msg;
    }

    @JsonIgnore
    public Message setMessage(String msg) {
        this.msg = msg;
        return this;
    }

    @JsonIgnore
    public int getCode() {
        return this.code;
    }

    @JsonIgnore
    public Message setCode(int code) {
        this.code = code;
        return this;
    }

    public Message addParameter(String param) {
        if (param == null || param.length() == 0) {
            return this;
        }
        if (this.parameters == null) {
            this.parameters = new LinkedList();
        }
        this.parameters.add(param);
        return this;
    }

    public Object clone() throws CloneNotSupportedException {
        Message clone = new Message();
        if (this.msg != null) {
            clone.msg = this.msg;
        }
        clone.code = this.code;
        if (this.parameters != null) {
            for (String p : this.parameters) {
                clone.addParameter(p);
            }
        }
        return clone;
    }

    public JsonNode toJsonNode() {
        ArrayNode message = this.mapper.createArrayNode();
        if (this.code != 0) {
            message.add(this.getCode());
        }
        message.add(this.getMessage());
        if (this.parameters != null) {
            for (String p : this.parameters) {
                message.add(p);
            }
        }
        return message;
    }

    public String toJsonString() {
        Object msg = "";
        try {
            return this.mapper.writeValueAsString(this.toJsonNode());
        }
        catch (Exception e) {
            msg = ", " + KrillString.quote(e.getLocalizedMessage());
            return "[620, \"Unable to generate JSON\"" + (String)msg + "]";
        }
    }
}

