/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.util;

import marmot.util.LevenshteinLattice;
import org.junit.Assert;
import org.junit.Test;

public class LevenshteinLatticeTest {
    @Test
    public void costTest() {
        String input = "A C B";
        String output = "A D B";
        LevenshteinLattice lattice = new LevenshteinLattice(input, output, 2, 2, 3);
        String actual = lattice.searchOperationSequence();
        String expected = "CCRCC";
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((long)3L, (long)lattice.getDistance());
        input = "A C B";
        output = "A DD B";
        lattice = new LevenshteinLattice(input, output, 2, 2, 3);
        actual = lattice.searchOperationSequence();
        expected = "CCIRCC";
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((long)5L, (long)lattice.getDistance());
        input = "A C B";
        output = "A DDDD B";
        lattice = new LevenshteinLattice(input, output, 2, 2, 3);
        actual = lattice.searchOperationSequence();
        expected = "CCIIIRCC";
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((long)9L, (long)lattice.getDistance());
        input = "A C B";
        output = "A DDDDD B";
        lattice = new LevenshteinLattice(input, output, 2, 2, 3);
        actual = lattice.searchOperationSequence();
        expected = "CCIIIIRCC";
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((long)11L, (long)lattice.getDistance());
        input = "A C B";
        output = "A DDDDDD B";
        lattice = new LevenshteinLattice(input, output, 2, 2, 3);
        actual = lattice.searchOperationSequence();
        expected = "CCIIIIIRCC";
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((long)13L, (long)lattice.getDistance());
        input = "C";
        output = "DD";
        lattice = new LevenshteinLattice(input, output, 2, 2, 3);
        actual = lattice.searchOperationSequence();
        System.err.println(actual);
        Assert.assertEquals((long)5L, (long)lattice.getDistance());
        expected = "IR";
        Assert.assertEquals((Object)expected, (Object)actual);
        input = "A CB";
        output = "A DDDDD B";
        lattice = new LevenshteinLattice(input, output, 2, 2, 3);
        actual = lattice.searchOperationSequence();
        Assert.assertEquals((long)13L, (long)lattice.getDistance());
        expected = "CCIIIIIRC";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void test() {
        String input = "<i>This isn't a sentence.</i>";
        String output = "This is n't a santence .";
        LevenshteinLattice lattice = new LevenshteinLattice(input, output, 1, 1, 2);
        String actual = lattice.searchOperationSequence();
        String expected = "DDDCCCCCCCICCCCCCCRCCCCCCICDDDD";
        Assert.assertEquals((Object)expected, (Object)actual);
        input = "ABCD";
        output = "";
        lattice = new LevenshteinLattice(input, output, 1, 1, 2);
        actual = lattice.searchOperationSequence();
        expected = "DDDD";
        Assert.assertEquals((Object)expected, (Object)actual);
        input = "";
        output = "ABCD";
        lattice = new LevenshteinLattice(input, output, 1, 1, 2);
        actual = lattice.searchOperationSequence();
        expected = "IIII";
        Assert.assertEquals((Object)expected, (Object)actual);
        input = "";
        output = "";
        lattice = new LevenshteinLattice(input, output, 1, 1, 2);
        actual = lattice.searchOperationSequence();
        expected = "";
        Assert.assertEquals((Object)expected, (Object)actual);
        input = "ABCD";
        output = "ABCD";
        lattice = new LevenshteinLattice(input, output, 1, 1, 2);
        actual = lattice.searchOperationSequence();
        expected = "CCCC";
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

