/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.index;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.ids_mannheim.korap.index.AbstractDocument;
import de.ids_mannheim.korap.index.MultiTermToken;
import de.ids_mannheim.korap.index.MultiTermTokenStream;
import de.ids_mannheim.korap.index.TextPrependedField;
import de.ids_mannheim.korap.response.MetaField;
import de.ids_mannheim.korap.util.CorpusDataException;
import de.ids_mannheim.korap.util.KrillDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FieldDocument
extends AbstractDocument {
    ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(FieldDocument.class);
    public static final boolean DEBUG = false;
    @JsonIgnore
    public Document doc = new Document();
    private FieldType tvField = new FieldType(TextField.TYPE_STORED);
    private FieldType tvNoField = new FieldType(TextField.TYPE_NOT_STORED);
    private FieldType keywordField = new FieldType(TextField.TYPE_STORED);

    public FieldDocument() {
        this.tvField.setStoreTermVectors(true);
        this.tvField.setStoreTermVectorPositions(true);
        this.tvField.setStoreTermVectorPayloads(true);
        this.tvField.setStoreTermVectorOffsets(false);
        this.tvNoField.setStoreTermVectors(true);
        this.tvNoField.setStoreTermVectorPositions(true);
        this.tvNoField.setStoreTermVectorPayloads(true);
        this.tvNoField.setStoreTermVectorOffsets(false);
        this.keywordField.setStoreTermVectors(false);
        this.keywordField.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
    }

    public Document compile() {
        for (MetaField mf : this.mFields) {
            switch (mf.type) {
                case "type:integer": {
                    try {
                        int val = Integer.parseInt(mf.values.get(0));
                        this.doc.add(new DoubleField(mf.key, (double)val, Field.Store.YES));
                    }
                    catch (NumberFormatException ne) {}
                    break;
                }
                case "type:date": {
                    KrillDate date = new KrillDate(mf.values.get(0));
                    if (date == null) break;
                    try {
                        this.doc.add(new IntField(mf.key, date.toInteger(), Field.Store.YES));
                    }
                    catch (NumberFormatException ne) {}
                    break;
                }
                case "type:string": {
                    this.doc.add(new StringField(mf.key, mf.values.get(0), Field.Store.YES));
                    break;
                }
                case "type:keywords": {
                    this.doc.add(new Field(mf.key, String.join((CharSequence)" ", mf.values), this.keywordField));
                    break;
                }
                case "type:text": {
                    this.doc.add(new TextPrependedField(mf.key, mf.values.get(0)));
                    break;
                }
                case "type:attachement": 
                case "type:store": {
                    this.doc.add(new StoredField(mf.key, mf.values.get(0)));
                }
            }
        }
        return this.doc;
    }

    public void addTV(String key, String value, String tsString) {
        this.addTV(key, value, new MultiTermTokenStream(tsString));
    }

    public void addTV(String key, String tsString) {
        this.addTV(key, new MultiTermTokenStream(tsString));
    }

    public void addTV(String key, String value, MultiTermTokenStream ts) {
        Field textField = new Field(key, value, this.tvField);
        textField.setTokenStream(ts);
        this.doc.add(textField);
    }

    public void addTV(String key, MultiTermTokenStream ts) {
        Field textField = new Field(key, (TokenStream)ts, this.tvNoField);
        this.doc.add(textField);
    }

    public String toString() {
        return this.doc.toString();
    }

    public MultiTermTokenStream newMultiTermTokenStream(String ts) {
        return new MultiTermTokenStream(ts);
    }

    public MultiTermTokenStream newMultiTermTokenStream() {
        return new MultiTermTokenStream();
    }

    public void setData(Map<String, Object> node) {
        this.setPrimaryData((String)node.get("text"));
        String fieldName = (String)node.get("name");
        MultiTermTokenStream mtts = this.newMultiTermTokenStream();
        for (ArrayList token : (ArrayList)node.get("stream")) {
            try {
                MultiTermToken mtt = new MultiTermToken((String)token.remove(0), new String[0]);
                for (String term : token) {
                    mtt.add(term);
                }
                mtts.addMultiTermToken(mtt);
            }
            catch (CorpusDataException cde) {
                this.addError(cde.getErrorCode(), cde.getMessage(), new String[0]);
            }
        }
        this.addTV(fieldName, this.getPrimaryData(), mtts);
        if (node.containsKey("foundries")) {
            this.addKeywords("foundries", (String)node.get("foundries"));
        }
        if (node.containsKey("layerInfos")) {
            this.addStored("layerInfos", (String)node.get("layerInfos"));
        }
        if (node.containsKey("tokenSource")) {
            this.addStored("tokenSource", (String)node.get("tokenSource"));
        }
    }

    public void setFields(ArrayList<Map<String, JsonNode>> fields) {
        if (!fields.get(0).containsKey("@type") && fields.get(0).containsKey("primaryData")) {
            this.setLegacyFields(fields);
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (Map<String, JsonNode> field : fields) {
            String value;
            if (!field.get("@type").asText().equals("koral:field")) continue;
            String type = field.get("type").asText();
            String key = field.get("key").asText();
            if (type.equals("type:string") || type.equals("type:keywords")) {
                if (field.get("value").isArray()) {
                    Iterator<JsonNode> i = field.get("value").elements();
                    sb.setLength(0);
                    while (i.hasNext()) {
                        sb.append(i.next().asText()).append(" ");
                    }
                    if (sb.length() > 1) {
                        sb.setLength(sb.length() - 1);
                    }
                    this.addKeywords(key, sb.toString());
                    continue;
                }
                if (type.equals("type:keywords")) {
                    this.addKeywords(key, field.get("value").asText());
                    continue;
                }
                this.addString(key, field.get("value").asText());
                continue;
            }
            if (type.equals("type:text")) {
                this.addText(key, field.get("value").asText());
                continue;
            }
            if (type.equals("type:integer")) {
                this.addInt(key, field.get("value").asInt());
                continue;
            }
            if (type.equals("type:store")) {
                value = field.get("value").asText();
                this.addStored(key, value);
                continue;
            }
            if (type.equals("type:attachement")) {
                value = field.get("value").asText();
                if (!value.startsWith("data:")) continue;
                this.addAttachement(key, value);
                continue;
            }
            if (type.equals("type:date")) {
                this.addDate(key, field.get("value").asText());
                continue;
            }
            log.error("Unknown field type {}", (Object)type);
        }
    }

    @JsonIgnore
    private void setLegacyFields(ArrayList<Map<String, JsonNode>> fields) {
        Map<String, JsonNode> primary = fields.remove(0);
        this.setPrimaryData(primary.get("primaryData").asText());
        for (Map<String, JsonNode> field : fields) {
            String fieldName = field.get("name").asText();
            MultiTermTokenStream mtts = this.newMultiTermTokenStream();
            Iterator<JsonNode> tokenIterator = field.get("data").elements();
            while (tokenIterator.hasNext()) {
                ArrayNode token = (ArrayNode)tokenIterator.next();
                try {
                    MultiTermToken mtt = new MultiTermToken(token.remove(0).asText(), new String[0]);
                    Iterator<JsonNode> terms = token.elements();
                    while (terms.hasNext()) {
                        mtt.add(terms.next().asText());
                    }
                    mtts.addMultiTermToken(mtt);
                }
                catch (CorpusDataException cde) {
                    this.addError(cde.getErrorCode(), cde.getMessage(), new String[0]);
                }
            }
            if (field.containsKey("foundries")) {
                this.addKeywords("foundries", field.get("foundries").asText());
            }
            this.addTV(fieldName, this.getPrimaryData(), mtts);
        }
    }
}

