/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanDistanceQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.DistanceSpans;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.util.Bits;

public class DistanceExclusionSpans
extends DistanceSpans {
    private int minDistance;
    private int maxDistance;
    private boolean isOrdered;
    private boolean hasMoreSecondSpans;

    public DistanceExclusionSpans(SpanDistanceQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
        this.minDistance = query.getMinDistance();
        this.maxDistance = query.getMaxDistance();
        this.isOrdered = query.isOrdered();
        this.hasMoreSpans = this.firstSpans.next();
        this.hasMoreSecondSpans = this.secondSpans.next();
    }

    @Override
    protected boolean advance() throws IOException {
        while (this.hasMoreSpans) {
            if (this.hasMoreSecondSpans) {
                this.forwardSecondSpans();
            }
            if (this.findMatch()) {
                this.hasMoreSpans = this.firstSpans.next();
                return true;
            }
            this.hasMoreSpans = this.firstSpans.next();
        }
        return false;
    }

    private void forwardSecondSpans() throws IOException {
        if (this.secondSpans.doc() < this.firstSpans.doc()) {
            this.hasMoreSecondSpans = this.secondSpans.skipTo(this.firstSpans.doc());
        }
        while (this.hasMoreSecondSpans && this.secondSpans.doc() == this.firstSpans.doc() && this.firstSpans.start() >= this.secondSpans.end() && (this.isOrdered || this.calculateActualDistance() > this.maxDistance)) {
            this.hasMoreSecondSpans = this.secondSpans.next();
        }
    }

    private int calculateActualDistance() {
        if (this.firstSpans.end() <= this.secondSpans.start()) {
            return this.secondSpans.start() - this.firstSpans.end() + 1;
        }
        return this.firstSpans.start() - this.secondSpans.end() + 1;
    }

    private boolean findMatch() throws IOException {
        if (!this.hasMoreSecondSpans || this.secondSpans.doc() > this.firstSpans.doc()) {
            this.setMatchProperties();
            return true;
        }
        if (this.minDistance == 0 && this.firstSpans.start() < this.secondSpans.end() && this.secondSpans.start() < this.firstSpans.end()) {
            return false;
        }
        int actualDistance = this.calculateActualDistance();
        if (actualDistance < this.minDistance || actualDistance > this.maxDistance) {
            this.setMatchProperties();
            return true;
        }
        return false;
    }

    private void setMatchProperties() throws IOException {
        this.matchDocNumber = this.firstSpans.doc();
        this.matchStartPosition = this.firstSpans.start();
        this.matchEndPosition = this.firstSpans.end();
        if (this.collectPayloads && this.firstSpans.isPayloadAvailable()) {
            this.matchPayload.addAll(this.firstSpans.getPayload());
        }
        this.setMatchFirstSpan(new CandidateSpan(this.firstSpans));
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target && !this.firstSpans.skipTo(target)) {
            this.hasMoreSpans = false;
            return false;
        }
        return this.advance();
    }

    @Override
    public long cost() {
        return this.firstSpans.cost() + this.secondSpans.cost();
    }
}

