/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.expr.DefaultedArgumentExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public abstract class URIFunctions
extends SystemFunction {
    protected static HashSet<String> hierarchicalSchemes;
    protected static HashSet<String> nonHierarchicalSchemes;
    protected static HashMap<String, String> defaultPorts;
    protected static final AtomicValue URI;
    protected static final AtomicValue PATH_SEPARATOR;
    protected static final AtomicValue QUERY_SEPARATOR;
    protected static final AtomicValue ALLOW_DEPRECATED_FEATURES;
    protected static final AtomicValue OMIT_DEFAULT_PORTS;
    protected static final AtomicValue UNC_PATH;
    protected static final AtomicValue SCHEME;
    protected static final AtomicValue AUTHORITY;
    protected static final AtomicValue USERINFO;
    protected static final AtomicValue HOST;
    protected static final AtomicValue PORT;
    protected static final AtomicValue PATH;
    protected static final AtomicValue FILEPATH;
    protected static final AtomicValue PATH_SEGMENTS;
    protected static final AtomicValue QUERY_PARAMETERS;
    protected static final AtomicValue QUERY;
    protected static final AtomicValue KEY;
    protected static final AtomicValue VALUE;
    protected static final AtomicValue FRAGMENT;
    protected static final AtomicValue HIERARCHICAL;
    protected static final Set<Character> unescapedUriCharacters;
    protected char pathSeparator = (char)47;
    protected char querySeparator = (char)38;
    protected boolean allowDeprecatedFeatures = false;
    protected boolean omitDefaultPorts = false;
    protected boolean hierarchical = true;
    protected boolean uncPath = false;

    private static Set<Character> unmodifiable(Set<Character> chars) {
        return Collections.unmodifiableSet(chars);
    }

    @Override
    public Expression makeFunctionCall(Expression ... arguments) {
        Expression[] newArgs = new Expression[]{arguments[0], arguments.length < 2 || arguments[1] instanceof DefaultedArgumentExpression ? Literal.makeLiteral(new DictionaryMap()) : arguments[1]};
        this.setArity(2);
        return super.makeFunctionCall(newArgs);
    }

    protected void checkOptions(Sequence[] arguments) throws XPathException {
        if (this.getArity() == 2) {
            String str;
            MapItem options = (MapItem)arguments[1].head();
            if (options == null) {
                options = new DictionaryMap();
            }
            if (options.get(PATH_SEPARATOR) != null) {
                str = options.get(PATH_SEPARATOR).getStringValue();
                if (str.length() != 1) {
                    throw new XPathException("The path separator must be a single character", "FOXX0000");
                }
                this.pathSeparator = str.charAt(0);
            }
            if (options.get(QUERY_SEPARATOR) != null) {
                str = options.get(QUERY_SEPARATOR).getStringValue();
                if (str.length() != 1) {
                    throw new XPathException("The query separator must be a single character", "FOXX0000");
                }
                this.querySeparator = str.charAt(0);
            }
            this.allowDeprecatedFeatures = options.get(ALLOW_DEPRECATED_FEATURES) != null && options.get(ALLOW_DEPRECATED_FEATURES).effectiveBooleanValue();
            this.omitDefaultPorts = options.get(OMIT_DEFAULT_PORTS) != null && options.get(OMIT_DEFAULT_PORTS).effectiveBooleanValue();
            this.uncPath = options.get(UNC_PATH) != null && options.get(UNC_PATH).effectiveBooleanValue();
        }
    }

    protected String encodePathSegment(GroundedValue value) throws XPathException {
        String input = value.getStringValue();
        StringBuilder output = new StringBuilder();
        for (int pos = 0; pos < input.length(); ++pos) {
            char ch = input.charAt(pos);
            if (ch > '\u007f' || unescapedUriCharacters.contains(Character.valueOf(ch))) {
                output.append(ch);
                continue;
            }
            output.append("%");
            output.append(this.toTwoHexDigits(ch));
        }
        return output.toString();
    }

    protected String encodeQueryPart(GroundedValue value) throws XPathException {
        String input = value.getStringValue();
        StringBuilder output = new StringBuilder();
        block5: for (int pos = 0; pos < input.length(); ++pos) {
            char ch = input.charAt(pos);
            if (ch == this.querySeparator) {
                output.append("%");
                output.append(this.toTwoHexDigits(this.querySeparator));
                continue;
            }
            switch (ch) {
                case '=': {
                    output.append("%3D");
                    continue block5;
                }
                case '&': {
                    output.append("%26");
                    continue block5;
                }
                case '/': 
                case '?': {
                    output.append(ch);
                    continue block5;
                }
                default: {
                    if (ch > '\u007f' || unescapedUriCharacters.contains(Character.valueOf(ch))) {
                        output.append(ch);
                        continue block5;
                    }
                    output.append("%");
                    output.append(this.toTwoHexDigits(ch));
                }
            }
        }
        return output.toString();
    }

    protected String encodeFragmentIdentifier(GroundedValue value) throws XPathException {
        String input = value.getStringValue();
        StringBuilder output = new StringBuilder();
        block3: for (int pos = 0; pos < input.length(); ++pos) {
            char ch = input.charAt(pos);
            if (ch > '\u007f' || unescapedUriCharacters.contains(Character.valueOf(ch))) {
                output.append(ch);
                continue;
            }
            switch (ch) {
                case '/': 
                case '?': {
                    output.append(ch);
                    continue block3;
                }
                default: {
                    output.append("%");
                    output.append(this.toTwoHexDigits(ch));
                }
            }
        }
        return output.toString();
    }

    private String toTwoHexDigits(int ch) {
        return String.format("%02X", ch);
    }

    static {
        char ch;
        hierarchicalSchemes = new HashSet<String>(Arrays.asList("http", "https", "ftp", "file"));
        nonHierarchicalSchemes = new HashSet<String>(Arrays.asList("urn", "mailto", "news", "tel", "tag", "jar"));
        defaultPorts = new HashMap();
        defaultPorts.put("http", "80");
        defaultPorts.put("https", "443");
        defaultPorts.put("ssh", "22");
        defaultPorts.put("ftp", "21");
        URI = new StringValue("uri");
        PATH_SEPARATOR = new StringValue("path-separator");
        QUERY_SEPARATOR = new StringValue("query-separator");
        ALLOW_DEPRECATED_FEATURES = new StringValue("allow-deprecated-features");
        OMIT_DEFAULT_PORTS = new StringValue("omit-default-ports");
        UNC_PATH = new StringValue("unc-path");
        SCHEME = new StringValue("scheme");
        AUTHORITY = new StringValue("authority");
        USERINFO = new StringValue("userinfo");
        HOST = new StringValue("host");
        PORT = new StringValue("port");
        PATH = new StringValue("path");
        FILEPATH = new StringValue("filepath");
        PATH_SEGMENTS = new StringValue("path-segments");
        QUERY_PARAMETERS = new StringValue("query-parameters");
        QUERY = new StringValue("query");
        KEY = new StringValue("key");
        VALUE = new StringValue("value");
        FRAGMENT = new StringValue("fragment");
        HIERARCHICAL = new StringValue("hierarchical");
        HashSet<Character> chars = new HashSet<Character>();
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + 1)) {
            chars.add(Character.valueOf(ch));
        }
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            chars.add(Character.valueOf(ch));
        }
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            chars.add(Character.valueOf(ch));
        }
        chars.add(Character.valueOf('-'));
        chars.add(Character.valueOf('.'));
        chars.add(Character.valueOf('_'));
        chars.add(Character.valueOf('~'));
        chars.add(Character.valueOf('!'));
        chars.add(Character.valueOf('$'));
        chars.add(Character.valueOf('&'));
        chars.add(Character.valueOf('\''));
        chars.add(Character.valueOf('('));
        chars.add(Character.valueOf(')'));
        chars.add(Character.valueOf('*'));
        chars.add(Character.valueOf('+'));
        chars.add(Character.valueOf(','));
        chars.add(Character.valueOf(';'));
        chars.add(Character.valueOf('='));
        chars.add(Character.valueOf(':'));
        chars.add(Character.valueOf('@'));
        unescapedUriCharacters = URIFunctions.unmodifiable(chars);
    }
}

