/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.sources;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xmlresolver.ResolvedResource;
import org.xmlresolver.sources.ResolverResourceInfo;
import org.xmlresolver.utils.RsrcUtils;

public class ResolverSAXSource
extends SAXSource
implements ResolverResourceInfo {
    public final URI resolvedURI;
    private final int statusCode;
    private final Map<String, List<String>> resolvedHeaders;

    public ResolverSAXSource(URI localURI, InputSource source) {
        super(source);
        this.resolvedURI = localURI;
        this.statusCode = 200;
        this.resolvedHeaders = Collections.emptyMap();
    }

    public ResolverSAXSource(ResolvedResource rsrc) {
        super(new InputSource(rsrc.getInputStream()));
        this.resolvedURI = rsrc.getLocalURI();
        this.statusCode = rsrc.getStatusCode();
        this.resolvedHeaders = rsrc.getHeaders();
    }

    @Override
    public URI getResolvedURI() {
        return this.resolvedURI;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.resolvedHeaders;
    }

    @Override
    public String getHeader(String headerName) {
        return RsrcUtils.getHeader(headerName, this.resolvedHeaders);
    }
}

