/*
 * Decompiled with CFR 0.152.
 */
package marmot.tokenize.preprocess;

import java.util.LinkedList;
import java.util.List;
import marmot.tokenize.openlp.Aligner;

public class Viewer {
    private Aligner.Result result_;
    private String tokenized_;
    private String untokenized_;

    public Viewer(String tokenized, String untokenized, Aligner.Result result2) {
        this.result_ = result2;
        this.tokenized_ = tokenized;
        this.untokenized_ = untokenized;
    }

    public List<String> getView() {
        List<Aligner.Pair> pairs = this.result_.pairs;
        if (pairs == null) {
            return null;
        }
        String tokenized = "|" + this.tokenized_.charAt(0);
        Object untokenized = pairs.get((int)0).b == 0 ? "|" + this.untokenized_.charAt(0) : "|\\";
        Object tok_nums = "|0";
        String untok_nums = "|" + pairs.get((int)0).b;
        int prev = pairs.get((int)0).b;
        for (int i = 1; i < pairs.size(); ++i) {
            String num_spaces;
            int a = pairs.get((int)i).a;
            int b = pairs.get((int)i).b;
            String num_spaces_a = this.spaceDiff(b, a);
            String num_spaces_b = this.spaceDiff(a, b);
            String diff_a = this.spaceDiff(a, 1);
            String diff_b = this.spaceDiff(b, 1);
            String string = num_spaces = diff_a.length() < diff_b.length() ? diff_b : diff_a;
            if (b == -1) {
                tok_nums = (String)tok_nums + "|" + i + num_spaces_a;
                untok_nums = untok_nums + "|-1" + num_spaces_b;
                tokenized = tokenized + "|" + this.tokenized_.charAt(a) + num_spaces;
                untokenized = (String)untokenized + "|\\" + num_spaces;
                continue;
            }
            if (b == prev) {
                tok_nums = (String)tok_nums + " " + i + num_spaces_a;
                untok_nums = untok_nums + " " + prev + num_spaces_b;
                tokenized = tokenized + " " + this.tokenized_.charAt(a) + num_spaces;
                untokenized = (String)untokenized + "  " + num_spaces;
                continue;
            }
            tok_nums = (String)tok_nums + "|" + a + num_spaces_a;
            untok_nums = untok_nums + "|" + b + num_spaces_b;
            tokenized = tokenized + "|" + this.tokenized_.charAt(a) + num_spaces;
            untokenized = (String)untokenized + "|" + this.untokenized_.charAt(b) + num_spaces;
            prev = b;
        }
        LinkedList<String> ret = new LinkedList<String>();
        ret.add(tokenized);
        ret.add((String)untokenized);
        ret.add((String)tok_nums);
        ret.add(untok_nums);
        return ret;
    }

    private String spaceDiff(int a, int b) {
        int a_count = a < 0 ? 1 : 0;
        a_count += (int)Math.log10(Math.abs(a));
        int b_count = b < 0 ? 1 : 0;
        b_count += (int)Math.log10(Math.abs(b));
        Object ret = "";
        for (int i = 0; i < a_count - b_count; ++i) {
            ret = (String)ret + " ";
        }
        return ret;
    }
}

