/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleSpanQuery
extends SpanQuery
implements Cloneable {
    protected SpanQuery firstClause = null;
    protected SpanQuery secondClause = null;
    protected List<SpanQuery> clauseList = null;
    protected String field;
    protected boolean collectPayloads;
    protected boolean isFieldNull = false;
    private static final Logger log = LoggerFactory.getLogger(SimpleSpanQuery.class);

    public SimpleSpanQuery() {
    }

    public SimpleSpanQuery(SpanQuery firstClause, boolean collectPayloads) {
        if (firstClause == null) {
            throw new IllegalArgumentException("The first clause cannot be null.");
        }
        this.field = firstClause.getField();
        if (this.field == null) {
            this.isFieldNull = true;
            log.warn("Field is null for " + firstClause.toString());
        }
        this.setFirstClause(firstClause);
        this.collectPayloads = collectPayloads;
    }

    public SimpleSpanQuery(SpanQuery firstClause, SpanQuery secondClause, boolean collectPayloads) {
        this(firstClause, collectPayloads);
        if (secondClause == null) {
            throw new IllegalArgumentException("The second clause cannot be null.");
        }
        this.checkField(secondClause);
        this.setSecondClause(secondClause);
    }

    public SimpleSpanQuery(SpanQuery firstClause, List<SpanQuery> secondClauses, boolean collectPayloads) {
        this(firstClause, collectPayloads);
        this.setClauseList(secondClauses);
    }

    public SimpleSpanQuery(List<SpanQuery> clauses, boolean collectPayloads) {
        this.collectPayloads = collectPayloads;
        this.setClauseList(clauses);
    }

    private void checkField(SpanQuery clause) {
        String field = clause.getField();
        if (field == null) {
            log.warn("Field is null for " + this.secondClause.toString());
            this.isFieldNull = true;
        } else if (!this.isFieldNull && !clause.getField().equals(field)) {
            throw new IllegalArgumentException("Clauses must have the same field.");
        }
    }

    public List<SpanQuery> getClauseList() {
        return this.clauseList;
    }

    public void setClauseList(List<SpanQuery> clauses) {
        if (clauses == null) {
            throw new IllegalArgumentException("The list of clauses cannot be null.");
        }
        if (clauses.size() < 1) {
            throw new IllegalArgumentException("The list of clauses cannot be empty.");
        }
        if (this.field == null) {
            this.field = clauses.get(0).getField();
        }
        for (SpanQuery clause : clauses) {
            if (clause == null) {
                throw new IllegalArgumentException("A clause cannot be null.");
            }
            this.checkField(clause);
        }
        this.clauseList = clauses;
    }

    @Override
    public String getField() {
        return this.field;
    }

    public SpanQuery getFirstClause() {
        return this.firstClause;
    }

    public void setFirstClause(SpanQuery firstClause) {
        this.firstClause = firstClause;
    }

    public SpanQuery getSecondClause() {
        return this.secondClause;
    }

    public void setSecondClause(SpanQuery secondClause) {
        this.secondClause = secondClause;
    }

    public boolean isCollectPayloads() {
        return this.collectPayloads;
    }

    public void setCollectPayloads(boolean collectPayloads) {
        this.collectPayloads = collectPayloads;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        if (terms == null) {
            throw new IllegalArgumentException("The term set cannot be null.");
        }
        if (this.firstClause != null) {
            this.firstClause.extractTerms(terms);
        }
        if (this.secondClause != null) {
            this.secondClause.extractTerms(terms);
        } else if (this.clauseList != null) {
            for (SpanQuery clause : this.clauseList) {
                clause.extractTerms(terms);
            }
        }
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SimpleSpanQuery clone = null;
        if (this.firstClause != null) {
            clone = this.updateClone(reader, clone, this.firstClause, 1);
        }
        if (this.secondClause != null) {
            clone = this.updateClone(reader, clone, this.secondClause, 2);
        } else if (this.clauseList != null) {
            clone = this.updateClone(reader, clone, this.clauseList);
        }
        return clone != null ? clone : this;
    }

    private SimpleSpanQuery updateClone(IndexReader reader, SimpleSpanQuery clone, List<SpanQuery> spanQueries) throws IOException {
        for (int i = 0; i < spanQueries.size(); ++i) {
            SpanQuery query = (SpanQuery)spanQueries.get(i).rewrite(reader);
            if (query.equals(spanQueries.get(i))) continue;
            if (clone == null) {
                clone = this.clone();
            }
            clone.getClauseList().set(i, query);
        }
        return clone;
    }

    private SimpleSpanQuery updateClone(IndexReader reader, SimpleSpanQuery clone, SpanQuery sq, int clauseNumber) throws IOException {
        SpanQuery query = (SpanQuery)sq.rewrite(reader);
        if (!query.equals(sq)) {
            if (clone == null) {
                clone = this.clone();
            }
            if (clauseNumber == 1) {
                clone.firstClause = query;
            } else {
                clone.secondClause = query;
            }
        }
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSpanQuery q = (SimpleSpanQuery)o;
        if (this.collectPayloads != q.collectPayloads) {
            return false;
        }
        if (!this.firstClause.equals(q.firstClause)) {
            return false;
        }
        if (this.secondClause != null && !this.secondClause.equals(q.secondClause)) {
            return false;
        }
        if (this.clauseList != null) {
            for (int i = 0; i < this.clauseList.size(); ++i) {
                if (this.clauseList.get(i).equals(q.getClauseList().get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hc = this.firstClause.hashCode();
        if (this.secondClause != null) {
            hc += this.secondClause.hashCode();
        } else if (this.clauseList != null) {
            for (int i = 0; i < this.clauseList.size(); ++i) {
                hc += this.clauseList.get(i).hashCode();
            }
        }
        hc ^= hc << 31 | hc >>> 3;
        return hc += Float.floatToRawIntBits(this.getBoost());
    }

    @Override
    public abstract SimpleSpanQuery clone();
}

