/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.wrap;

import de.ids_mannheim.korap.query.SpanSubspanQuery;
import de.ids_mannheim.korap.query.wrap.SpanQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanRepetitionQueryWrapper;
import de.ids_mannheim.korap.util.QueryException;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanSubspanQueryWrapper
extends SpanQueryWrapper {
    private SpanQueryWrapper subquery;
    private int startOffset;
    private int length;
    private static final Logger log = LoggerFactory.getLogger(SpanSubspanQueryWrapper.class);
    public static final boolean DEBUG = false;

    public SpanSubspanQueryWrapper(SpanQueryWrapper sqw, int startOffset, int length) throws QueryException {
        if (length < 0) {
            throw new QueryException("SpanSubspanQuery cannot have length less than 0.");
        }
        this.subquery = sqw;
        if (this.subquery == null) {
            return;
        }
        this.isNull = false;
        this.startOffset = startOffset;
        this.length = length;
        if (this.subquery.isEmpty()) {
            this.handleEmptySubquery();
        } else if (this.subquery.isNegative()) {
            this.handleNegativeSubquery();
        }
        this.maybeUnsorted = sqw.maybeUnsorted();
    }

    private void handleNegativeSubquery() {
        this.isNegative = true;
        if (this.startOffset < 0) {
            int max = Math.abs(this.startOffset) + this.length;
            this.subquery.setMax(max);
            this.startOffset = max + this.startOffset;
        } else {
            int endOffset = this.startOffset + this.length;
            if (this.subquery.getMax() > endOffset) {
                this.subquery.setMax(this.startOffset + this.length);
            }
        }
        this.subquery.setMin(this.startOffset);
        this.subquery.isOptional = false;
        this.min = this.max = this.subquery.max - this.subquery.min;
    }

    private void handleEmptySubquery() {
        if (this.subquery instanceof SpanRepetitionQueryWrapper) {
            this.isEmpty = true;
        }
        if (this.startOffset >= this.subquery.getMax()) {
            this.isNull = true;
            return;
        }
        if (this.startOffset < 0) {
            this.startOffset = this.subquery.getMax() + this.startOffset;
        }
        this.subquery.isOptional = false;
        this.subquery.setMin(this.startOffset);
        int endOffset = this.startOffset + this.length;
        if (this.length == 0) {
            this.length = this.subquery.getMax() - this.startOffset;
        } else if (this.subquery.getMax() > endOffset || this.subquery.getMax() == 0) {
            this.subquery.setMax(endOffset);
        } else if (this.subquery.getMax() < endOffset) {
            this.length = this.subquery.max - this.subquery.min;
        }
        this.setMax(this.subquery.max);
        this.setMin(this.subquery.min);
    }

    @Override
    public SpanQuery toFragmentQuery() throws QueryException {
        if (this.isNull()) {
            return null;
        }
        SpanQuery sq = this.subquery.retrieveNode(this.retrieveNode).toFragmentQuery();
        if (sq == null) {
            return null;
        }
        if (sq instanceof SpanTermQuery) {
            if (this.subquery.isNegative()) {
                return sq;
            }
            if (!(this.startOffset != 0 && this.startOffset != -1 || this.length != 1 && this.length != 0)) {
                return sq;
            }
            return null;
        }
        return new SpanSubspanQuery(sq, this.startOffset, this.length, true);
    }

    @Override
    public boolean isNegative() {
        return this.subquery.isNegative();
    }

    @Override
    public boolean isOptional() {
        if (this.startOffset > 0) {
            return false;
        }
        return this.subquery.isOptional();
    }
}

