/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.log;

import java.io.PrintStream;
import java.util.Objects;
import opennlp.tools.commons.Internal;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@Internal
public class LogPrintStream
extends PrintStream {
    private final Logger logger;
    private final Level level;

    public LogPrintStream(Logger logger) {
        this(logger, Level.INFO);
    }

    public LogPrintStream(Logger logger, Level level) {
        super(LogPrintStream.nullOutputStream());
        Objects.requireNonNull(logger, "logger must not be NULL.");
        Objects.requireNonNull(level, "log level must not be NULL.");
        this.logger = logger;
        this.level = level;
    }

    @Override
    public PrintStream printf(String format, Object ... args2) {
        this.log(String.format(format, args2));
        return this;
    }

    @Override
    public void println(String msg) {
        this.log(msg);
    }

    private void log(String msg) {
        switch (this.level) {
            case TRACE: {
                this.logger.trace(msg);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg);
                break;
            }
            case INFO: {
                this.logger.info(msg);
                break;
            }
            case WARN: {
                this.logger.warn(msg);
                break;
            }
            case ERROR: {
                this.logger.error(msg);
            }
        }
    }
}

