/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ngram;

import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import opennlp.tools.util.StringUtil;

public class NGramCharModel
implements Iterable<CharSequence> {
    protected static final String COUNT = "count";
    private final Map<CharSequence, Integer> mNGrams = new HashMap<CharSequence, Integer>();

    public int getCount(CharSequence ngram) {
        Integer count2 = ngram instanceof CharBuffer ? this.mNGrams.get(ngram) : this.mNGrams.get(CharBuffer.wrap(ngram));
        if (count2 == null) {
            return 0;
        }
        return count2;
    }

    public void setCount(CharSequence ngram, int count2) {
        Integer oldCount = this.mNGrams.put(ngram, count2);
        if (oldCount == null) {
            this.mNGrams.remove(ngram);
            throw new NoSuchElementException();
        }
    }

    public void add(CharSequence ngram) {
        if (this.contains(ngram)) {
            this.setCount(ngram, this.getCount(ngram) + 1);
        } else {
            this.mNGrams.put(CharBuffer.wrap(ngram), 1);
        }
    }

    public void add(CharSequence chars, int minLength, int maxLength) {
        CharBuffer cb = StringUtil.toLowerCaseCharBuffer(chars);
        for (int lengthIndex = minLength; lengthIndex < maxLength + 1; ++lengthIndex) {
            int textIndex = 0;
            while (textIndex + lengthIndex - 1 < cb.length()) {
                CharBuffer gram = cb.subSequence(textIndex, textIndex + lengthIndex);
                this.add(gram);
                ++textIndex;
            }
        }
    }

    public void remove(CharSequence ngram) {
        if (ngram instanceof CharBuffer) {
            this.mNGrams.remove(ngram);
        } else if (ngram != null) {
            this.mNGrams.remove(CharBuffer.wrap(ngram));
        }
    }

    public boolean contains(CharSequence ngram) {
        if (ngram instanceof CharBuffer) {
            return this.mNGrams.containsKey(ngram);
        }
        if (ngram != null) {
            return this.mNGrams.containsKey(CharBuffer.wrap(ngram));
        }
        return false;
    }

    public int size() {
        return this.mNGrams.size();
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return this.mNGrams.keySet().iterator();
    }

    public int numberOfGrams() {
        int counter = 0;
        for (CharSequence ngram : this) {
            counter += this.getCount(ngram);
        }
        return counter;
    }

    public void cutoff(int cutoffUnder, int cutoffOver) {
        if (cutoffUnder > 0 || cutoffOver < Integer.MAX_VALUE) {
            Iterator<CharSequence> it = this.iterator();
            while (it.hasNext()) {
                CharSequence ngram = it.next();
                int count2 = this.getCount(ngram);
                if (count2 >= cutoffUnder && count2 <= cutoffOver) continue;
                it.remove();
            }
        }
    }

    public boolean equals(Object obj) {
        boolean result2;
        if (obj == this) {
            result2 = true;
        } else if (obj instanceof NGramCharModel) {
            NGramCharModel model = (NGramCharModel)obj;
            result2 = this.mNGrams.equals(model.mNGrams);
        } else {
            result2 = false;
        }
        return result2;
    }

    public String toString() {
        return "Size: " + this.size();
    }

    public int hashCode() {
        return this.mNGrams.hashCode();
    }
}

