/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.wrap;

import de.ids_mannheim.korap.constants.RelationDirection;
import de.ids_mannheim.korap.query.SpanFocusQuery;
import de.ids_mannheim.korap.query.SpanRelationMatchQuery;
import de.ids_mannheim.korap.query.SpanRelationQuery;
import de.ids_mannheim.korap.query.wrap.SpanQueryWrapper;
import de.ids_mannheim.korap.util.QueryException;
import org.apache.lucene.search.spans.SpanQuery;

public class SpanRelationWrapper
extends SpanQueryWrapper {
    private SpanQueryWrapper relationQuery;
    private SpanQueryWrapper subQuery1;
    private SpanQueryWrapper subQuery2;
    private RelationDirection direction;

    public SpanRelationWrapper(SpanQueryWrapper relationWrapper, SpanQueryWrapper operand1, SpanQueryWrapper operand2) {
        this.relationQuery = relationWrapper;
        if (this.relationQuery == null) {
            return;
        }
        this.isNull = false;
        if (this.relationQuery.isEmpty) {
            this.isEmpty = true;
            return;
        }
        this.subQuery1 = operand1;
        this.subQuery2 = operand2;
        this.maybeUnsorted = true;
    }

    @Override
    public SpanQuery toFragmentQuery() throws QueryException {
        if (this.isNull() || this.isEmpty()) {
            return null;
        }
        SpanQuery relationTermQuery = this.relationQuery.retrieveNode(this.retrieveNode).toFragmentQuery();
        if (relationTermQuery == null) {
            return null;
        }
        SpanRelationQuery rq = new SpanRelationQuery(relationTermQuery, true, this.direction);
        if (this.subQuery1.isEmpty) {
            if (!this.subQuery2.isEmpty) {
                SpanQuery subq2 = this.subQuery2.retrieveNode(this.retrieveNode).toFragmentQuery();
                if (this.subQuery1.hasClass) {
                    rq.setSourceClass(this.subQuery1.getClassNumber());
                }
                return new SpanRelationMatchQuery(rq, subq2, true);
            }
        } else if (this.subQuery2.isEmpty) {
            if (!this.subQuery1.isEmpty) {
                SpanQuery subq1 = this.subQuery1.retrieveNode(this.retrieveNode).toFragmentQuery();
                if (this.subQuery2.hasClass) {
                    rq.setTargetClass(this.subQuery2.getClassNumber());
                }
                return new SpanRelationMatchQuery(rq, subq1, true);
            }
        } else {
            SpanQuery subq1 = this.subQuery1.retrieveNode(this.retrieveNode).toFragmentQuery();
            SpanQuery subq2 = this.subQuery2.retrieveNode(this.retrieveNode).toFragmentQuery();
            return new SpanRelationMatchQuery(rq, subq1, subq2, true);
        }
        if (this.subQuery1.hasClass) {
            rq.setSourceClass(this.subQuery1.getClassNumber());
        }
        if (this.subQuery2.hasClass) {
            rq.setTargetClass(this.subQuery2.getClassNumber());
        }
        SpanFocusQuery fq = new SpanFocusQuery((SpanQuery)rq, rq.getTempClassNumbers());
        fq.setMatchTemporaryClass(true);
        fq.setRemoveTemporaryClasses(true);
        fq.setSorted(false);
        return fq;
    }

    public void setDirection(RelationDirection direction) {
        this.direction = direction;
    }

    public RelationDirection getDirection() {
        return this.direction;
    }
}

