/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.IdentityField;
import com.saxonica.ee.schema.IdentitySelector;
import com.saxonica.ee.schema.Key;
import com.saxonica.ee.schema.KeyRef;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.UserSchemaComponent;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public abstract class IdentityConstraint
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent {
    private IdentitySelector selector = null;
    private List<IdentityField> fields = new ArrayList<IdentityField>(3);
    private StructuredQName constraintName;
    private boolean ordered;

    public abstract String getConstraintCategory();

    protected IdentityConstraint() {
    }

    public void addField(IdentityField field) {
        if (field != null) {
            this.fields.add(field);
        }
    }

    public List<IdentityField> getFields() {
        return this.fields;
    }

    public String getName() {
        return this.constraintName.getLocalPart();
    }

    public NamespaceUri getTargetNamespace() {
        return this.constraintName.getNamespaceUri();
    }

    public IdentitySelector getSelector() {
        return this.selector;
    }

    public void setSelector(IdentitySelector selector) {
        this.selector = selector;
    }

    public void setConstraintName(StructuredQName nc) {
        this.constraintName = nc;
    }

    public StructuredQName getConstraintName() {
        return this.constraintName;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        this.setFixupStatus(SchemaValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        String err = null;
        if (!NameChecker.isValidNCName(StringTool.codePoints(this.getName()))) {
            err = "The name of an IdentityConstraint must be an NCName.";
        } else if (this.selector == null) {
            err = "Selector for IdentityConstraint cannot be null.";
        } else if (this.fields.size() < 1) {
            err = "There must be at least one field in an identity constraint.";
        }
        if (err != null) {
            compiler.error(err, this);
            return false;
        }
        return true;
    }

    public void typeCheck(SchemaCompiler compiler, SchemaType contextType) throws XPathException {
        EnterpriseConfiguration config = compiler.getConfiguration();
        IndependentContext env = new IndependentContext(config);
        env.setWarningHandler((message, code, loc) -> compiler.warning(message, code, this));
        env.setSchemaAware(true);
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        ContentTypeTest contextItemType = new ContentTypeTest(1, contextType, config, false);
        ContextItemStaticInfo cit = config.makeContextItemStaticInfo(contextItemType, true);
        this.selector.setSelectExpression(this.selector.getSelectExpression().typeCheck(visitor, cit));
        ItemType selectorType = this.selector.getSelectExpression().getItemType();
        if (selectorType instanceof NodeTest && ((NodeTest)selectorType).getContentType() != AnyType.getInstance()) {
            ContextItemStaticInfo sit = config.makeContextItemStaticInfo(selectorType, false);
            for (IdentityField field : this.fields) {
                boolean listValued;
                SchemaType contentType;
                field.setSelectExpression(field.getSelectExpression().typeCheck(visitor, sit));
                int card = field.getCardinality(visitor, sit);
                if (Cardinality.allowsMany(card)) {
                    compiler.warning("The field expression (" + field.getXPath() + ") may select multiple nodes, which would make the instance document invalid", "SXSD1004", field);
                } else if (this instanceof Key && Cardinality.allowsZero(card)) {
                    compiler.warning("The field expression (" + field.getXPath() + ") may select no nodes, which would make the instance document invalid", "SXSD1004", field);
                }
                NodeTest fieldType = (NodeTest)field.getSelectExpression().getItemType();
                AtomicType atomizedType = fieldType.getAtomizedItemType();
                if (atomizedType == null) {
                    compiler.warning("The node selected by the field expression cannot be atomized", "SXSD1005", field);
                }
                if (!((contentType = fieldType.getContentType()) == AnyType.getInstance() || contentType.isSimpleType() || contentType.isComplexType() && ((ComplexType)contentType).isSimpleContent())) {
                    compiler.warning("The node selected by the field expression must have a simple type, or a complex type with simple content", "SXSD1005", field);
                }
                boolean bl = listValued = contentType.isSimpleType() && ((SimpleType)contentType).isListType();
                if (atomizedType == null || !atomizedType.isAtomicType() || contentType == BuiltInAtomicType.ANY_ATOMIC) continue;
                field.setBuiltInBaseType((BuiltInAtomicType)atomizedType.getBuiltInBaseType(), listValued);
            }
        }
    }

    public boolean isSameDeclaration(IdentityConstraint other) {
        return this == other || this.getConstraintName().equals(other.getConstraintName()) && this.hasSameLocation(other);
    }

    @Override
    public void elaborate(SchemaCompiler compiler) {
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.setIsSerialized(this);
        String kind = this.getConstraintCategory();
        serializer.startElement(kind);
        serializer.emitAttribute("id", serializer.getId(this, false));
        serializer.emitAttribute("name", this.getName());
        if (this.getTargetNamespace() != null) {
            serializer.emitAttribute("targetNamespace", this.getTargetNamespace().toString());
        }
        if (this instanceof KeyRef) {
            IdentityConstraint target = (IdentityConstraint)((KeyRef)this).getTarget();
            serializer.emitAttribute("key", serializer.getId(target, false));
        }
        serializer.startElement("selector");
        serializer.emitNamespaceContext(this.selector.getNamespaceContext());
        serializer.emitAttribute("xpath", this.selector.getXPath());
        serializer.emitAttribute("defaultNamespace", this.selector.getXPathDefaultNamespace().toString());
        serializer.endElement();
        for (IdentityField f : this.fields) {
            serializer.startElement("field");
            serializer.emitNamespaceContext(f.getNamespaceContext());
            serializer.emitAttribute("xpath", f.getXPath());
            serializer.emitAttribute("defaultNamespace", f.getXPathDefaultNamespace().toString());
            BuiltInAtomicType baseType = f.getBuiltInBaseType();
            if (baseType != null) {
                serializer.emitAttribute("type", "#" + baseType.getName() + (f.isListValued() ? "*" : ""));
            }
            serializer.endElement();
        }
        serializer.endElement();
    }

    @Override
    public FunctionItem getComponentAsFunction() {
        IdentityConstraint thisConstraint = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Identity-Constraint Definition");
                }
                case "implementation": {
                    return new ObjectValue<IdentityConstraint>(thisConstraint);
                }
                case "name": {
                    return new StringValue(this.getName(), (AtomicType)BuiltInAtomicType.NCNAME);
                }
                case "target namespace": {
                    return new AnyURIValue(this.getTargetNamespace().toUnicodeString());
                }
                case "identity-constraint category": {
                    String kind = this.getConstraintCategory();
                    return new StringValue(kind);
                }
                case "selector": {
                    IdentitySelector selector = this.getSelector();
                    return SchemaStructure.makeXPathExpressionPropertyRecord(selector.getXPath(), selector.getNamespaceContext(), selector.getSchemaDocumentURI());
                }
                case "fields": {
                    ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                    for (IdentityField field : this.getFields()) {
                        list.add(SchemaStructure.makeXPathExpressionPropertyRecord(field.getXPath(), field.getNamespaceContext(), field.getSchemaDocumentURI()));
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "referenced key": {
                    if (this instanceof KeyRef) {
                        return ((KeyRef)this).getTarget().getComponentAsFunction();
                    }
                    return EmptySequence.getInstance();
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

