/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.xtupdate;

import com.saxonica.ee.update.InsertExpression;
import com.saxonica.ee.xtupdate.SaxonUpdate;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class SaxonInsert
extends ExtensionInstruction {
    private Expression select;
    private String positionAtt;

    @Override
    protected boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected void prepareAttributes() {
        String selectAtt = null;
        block8: for (AttributeInfo att : this.attributes()) {
            String f;
            NodeName attName = att.getNodeName();
            String value = att.getValue();
            switch (f = attName.getDisplayName()) {
                case "select": {
                    selectAtt = value;
                    this.select = this.makeExpression(selectAtt, att);
                    continue block8;
                }
                case "position": {
                    String val = Whitespace.trim(value);
                    if (!(val.equals("after") || val.equals("before") || val.equals("first") || val.equals("last"))) {
                        this.invalidAttribute("position", "after|before|first|last");
                    }
                    this.positionAtt = val;
                    continue block8;
                }
            }
            this.checkUnknownAttribute(attName);
        }
        if (selectAtt == null) {
            this.select = new ContextItemExpression();
            this.select.setLocation(this.allocateLocation());
        }
        if (this.positionAtt == null) {
            this.positionAtt = "last";
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.getConfiguration().checkLicensedFeature(2, "saxon:insert", this.getPackageData().getLocalLicenseId());
        this.select = this.typeCheck("select", this.select);
        SaxonUpdate.checkContainment(this);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression content = this.compileSequenceConstructor(exec, decl, false);
        int pos = SaxonInsert.interpretPosition(this.positionAtt);
        return new InsertExpression(content, this.select, pos, 3, true, true);
    }

    public static int interpretPosition(String p) {
        switch (p) {
            case "first": {
                return 131;
            }
            case "last": {
                return 132;
            }
            case "before": {
                return 134;
            }
            case "after": {
                return 133;
            }
        }
        return -1;
    }

    public static String encodePosition(int p) {
        switch (p) {
            case 131: {
                return "first";
            }
            case 132: {
                return "last";
            }
            case 134: {
                return "before";
            }
            case 133: {
                return "after";
            }
        }
        return "??";
    }
}

