/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.util;

import java.util.Arrays;
import marmot.util.Aspell;
import marmot.util.AspellLexicon;
import marmot.util.HashLexicon;
import marmot.util.Lexicon;
import marmot.util.LineIterator;
import marmot.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class AspellTest {
    @Test
    public void test() {
        Aspell aspell = new Aspell("/mounts/Users/cisintern/muellets/cistern/marmot/cmd/marmot_aspell", "en", "utf-8");
        Assert.assertTrue((boolean)aspell.isCorrect("home"));
        Assert.assertFalse((boolean)aspell.isCorrect("hme"));
        aspell.shutdown();
    }

    @Test
    public void lexiconTest() {
        AspellLexicon aspell = new AspellLexicon(StringUtils.Mode.lower, "/mounts/Users/cisintern/muellets/cistern/marmot/cmd/marmot_aspell", "de");
        int[] array = new int[Lexicon.ARRAY_LENGTH];
        array[StringUtils.Shape.AllCap.ordinal()] = 1;
        array[Lexicon.ARRAY_LENGTH - 1] = 1;
        Assert.assertArrayEquals((int[])aspell.getCount("DDR"), (int[])array);
        Arrays.fill(array, 0);
        Assert.assertArrayEquals((int[])aspell.getCount("123"), null);
        array[StringUtils.Shape.FirstCap.ordinal()] = 1;
        array[StringUtils.Shape.Lower.ordinal()] = 1;
        array[StringUtils.Shape.AllCap.ordinal()] = 1;
        array[Lexicon.ARRAY_LENGTH - 1] = 1;
        Assert.assertArrayEquals((int[])array, (int[])aspell.getCount("Mach"));
        Arrays.fill(array, 0);
        array[StringUtils.Shape.NoLetter.ordinal()] = 1;
        array[Lexicon.ARRAY_LENGTH - 1] = 1;
        Assert.assertArrayEquals((int[])array, (int[])aspell.getCount("."));
        Arrays.fill(array, 0);
    }

    @Test
    public void lexiconTest2() {
        String path = "/mounts/data/proj/marmot/lemmatizer/data/de/aspell.txt";
        AspellLexicon aspell = new AspellLexicon(StringUtils.Mode.lower, "/mounts/Users/cisintern/muellets/cistern/marmot/cmd/marmot_aspell", "de");
        HashLexicon lexicon = HashLexicon.readFromFile(path, 1);
        LineIterator iterator2 = new LineIterator(path);
        while (iterator2.hasNext()) {
            int[] aspell_counts;
            String word;
            int[] hash_counts;
            Object line = iterator2.next();
            if (line.size() <= 0 || Arrays.equals(hash_counts = lexicon.getCount(word = (String)line.get(0)), aspell_counts = aspell.getCount(word))) continue;
            System.err.format("%s %s %s\n", word, Arrays.toString(hash_counts), Arrays.toString(aspell_counts));
        }
    }
}

