/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.UpdateParser;
import com.saxonica.expr.XQueryParserExtensionPE;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.query.Annotation;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.trans.XPathException;

public class XQueryParserExtensionEE
extends XQueryParserExtensionPE {
    private boolean acceptUpdateSyntax = false;
    private boolean foundRevalidationDeclaration = false;

    public XQueryParserExtensionEE(boolean updating) {
        this.acceptUpdateSyntax = updating;
    }

    @Override
    public void parseRevalidationDeclaration(XQueryParser p) throws XPathException {
        int val;
        this.checkXQueryUpdate(p);
        if (this.foundRevalidationDeclaration) {
            p.grumble("declare revalidation appears more than once", "XUST0003");
        }
        this.foundRevalidationDeclaration = true;
        p.nextToken();
        p.expect(201);
        Tokenizer t = p.getTokenizer();
        if ("strict".equals(t.currentTokenValue)) {
            val = 1;
        } else if ("lax".equals(t.currentTokenValue)) {
            val = 2;
        } else if ("skip".equals(t.currentTokenValue)) {
            val = 4;
        } else {
            p.grumble("revalidation mode must be 'strict', 'lax', or 'skip'");
            val = 4;
        }
        ((QueryModule)p.getStaticContext()).setRevalidationMode(val);
        p.nextToken();
    }

    @Override
    public void parseUpdatingFunctionDeclaration(XQueryParser p) throws XPathException {
        p.parseFunctionDeclaration(AnnotationList.singleton(new Annotation(Annotation.UPDATING)));
    }

    @Override
    protected Expression parseExtendedExprSingle(XPathParser p) throws XPathException {
        if (this.acceptUpdateSyntax) {
            Tokenizer t = p.getTokenizer();
            switch (t.currentToken) {
                case 219: {
                    return UpdateParser.parseTransformExpression(p);
                }
                case 125: {
                    return UpdateParser.parseInsertExpression(p);
                }
                case 126: {
                    return UpdateParser.parseDeleteExpression(p);
                }
                case 127: {
                    return UpdateParser.parseReplaceNodeExpression(p);
                }
                case 128: {
                    return UpdateParser.parseReplaceValueExpression(p);
                }
                case 130: {
                    return UpdateParser.parseRenameExpression(p);
                }
            }
        }
        return super.parseExtendedExprSingle(p);
    }

    private void checkXQueryUpdate(XPathParser p) throws XPathException {
        if (!this.acceptUpdateSyntax) {
            p.grumble("XQuery update syntax encountered in a non-updating query");
        }
    }
}

