/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanDistanceQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.DistanceSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public abstract class UnorderedDistanceSpans
extends DistanceSpans {
    protected int minDistance;
    protected int maxDistance;
    protected boolean hasMoreFirstSpans;
    protected boolean hasMoreSecondSpans;
    protected List<CandidateSpan> firstSpanList;
    protected List<CandidateSpan> secondSpanList;
    protected List<CandidateSpan> matchList;
    private long matchCost;
    protected int currentDocNum;

    public UnorderedDistanceSpans(SpanDistanceQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
        this.minDistance = query.getMinDistance();
        this.maxDistance = query.getMaxDistance();
        this.firstSpanList = new ArrayList<CandidateSpan>();
        this.secondSpanList = new ArrayList<CandidateSpan>();
        this.matchList = new ArrayList<CandidateSpan>();
        this.hasMoreFirstSpans = this.firstSpans.next();
        this.hasMoreSecondSpans = this.secondSpans.next();
        this.hasMoreSpans = this.hasMoreFirstSpans && this.hasMoreSecondSpans;
    }

    @Override
    protected boolean advance() throws IOException {
        while (this.hasMoreSpans || !this.matchList.isEmpty()) {
            if (!this.matchList.isEmpty()) {
                this.setMatchProperties();
                return true;
            }
            if (!this.prepareLists()) continue;
            this.setMatchList();
        }
        return false;
    }

    protected abstract boolean prepareLists() throws IOException;

    protected void setMatchList() throws IOException {
        this.hasMoreFirstSpans = this.setCandidateList(this.firstSpanList, this.firstSpans, this.hasMoreFirstSpans, this.secondSpanList);
        this.hasMoreSecondSpans = this.setCandidateList(this.secondSpanList, this.secondSpans, this.hasMoreSecondSpans, this.firstSpanList);
        if (!this.firstSpanList.isEmpty() && !this.secondSpanList.isEmpty()) {
            CandidateSpan currentFirstSpan = this.firstSpanList.get(0);
            CandidateSpan currentSecondSpan = this.secondSpanList.get(0);
            if (currentFirstSpan.getStart() < currentSecondSpan.getStart() || this.isLastCandidateSmaller(currentFirstSpan, currentSecondSpan)) {
                this.matchList = this.findMatches(currentFirstSpan, this.secondSpanList, true);
                this.updateList(this.firstSpanList);
            } else {
                this.matchList = this.findMatches(currentSecondSpan, this.firstSpanList, false);
                this.updateList(this.secondSpanList);
                if (currentFirstSpan.getStart() == currentSecondSpan.getStart() && currentFirstSpan.getEnd() == currentSecondSpan.getEnd()) {
                    this.matchList.addAll(this.findMatches(currentFirstSpan, this.secondSpanList, false));
                    Collections.sort(this.matchList);
                    this.updateList(this.firstSpanList);
                }
            }
        } else if (!this.secondSpanList.isEmpty()) {
            this.updateList(this.secondSpanList);
        } else if (!this.firstSpanList.isEmpty()) {
            this.updateList(this.firstSpanList);
        }
    }

    private boolean isLastCandidateSmaller(CandidateSpan currentFirstSpan, CandidateSpan currentSecondSpan) {
        if (currentFirstSpan.getEnd() == currentSecondSpan.getEnd()) {
            int firstEnd;
            int secondEnd = this.secondSpanList.get(this.secondSpanList.size() - 1).getEnd();
            return secondEnd < (firstEnd = this.firstSpanList.get(this.firstSpanList.size() - 1).getEnd());
        }
        return false;
    }

    protected abstract void updateList(List<CandidateSpan> var1);

    protected abstract boolean setCandidateList(List<CandidateSpan> var1, Spans var2, boolean var3, List<CandidateSpan> var4) throws IOException;

    protected abstract List<CandidateSpan> findMatches(CandidateSpan var1, List<CandidateSpan> var2, boolean var3);

    protected CandidateSpan createMatchCandidate(CandidateSpan target, CandidateSpan cs, boolean isDistanceZero, boolean isTargetFirstSpan) {
        int start = Math.min(target.getStart(), cs.getStart());
        int end = Math.max(target.getEnd(), cs.getEnd());
        int doc = target.getDoc();
        long cost = target.getCost() + cs.getCost();
        LinkedList<byte[]> payloads = new LinkedList<byte[]>();
        if (this.collectPayloads) {
            if (target.getPayloads() != null) {
                payloads.addAll(target.getPayloads());
            }
            if (cs.getPayloads() != null) {
                payloads.addAll(cs.getPayloads());
            }
        }
        CandidateSpan match = new CandidateSpan(start, end, doc, cost, payloads);
        if (isTargetFirstSpan) {
            match.setChildSpan(target);
            match.setSecondChildSpan(cs);
        } else {
            match.setChildSpan(cs);
            match.setSecondChildSpan(target);
        }
        return match;
    }

    private void setMatchProperties() {
        CandidateSpan cs = this.matchList.get(0);
        this.matchDocNumber = cs.getDoc();
        this.matchStartPosition = cs.getStart();
        this.matchEndPosition = cs.getEnd();
        this.matchCost = cs.getCost();
        this.matchPayload.addAll(cs.getPayloads());
        this.matchList.remove(0);
        this.setMatchFirstSpan(cs.getChildSpan());
        this.setMatchSecondSpan(cs.getSecondChildSpan());
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.secondSpans.doc() < target && !this.secondSpans.skipTo(target)) {
            this.hasMoreSpans = false;
            return false;
        }
        this.firstSpanList.clear();
        this.secondSpanList.clear();
        this.matchPayload.clear();
        this.isStartEnumeration = false;
        return this.advance();
    }

    @Override
    public long cost() {
        return this.matchCost;
    }
}

