/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.AttributeWildcard;
import com.saxonica.ee.schema.ComponentReference;
import com.saxonica.ee.schema.MissingComponentExceptionImpl;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaStructure;
import java.util.Stack;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaValidationStatus;

public final class AttributeGroupReference
extends SchemaStructure
implements ComponentReference,
SchemaComponent {
    private StructuredQName qName;
    private AttributeGroupDecl target;
    private boolean dangling = false;

    public AttributeGroupReference(EnterpriseConfiguration config, StructuredQName target) {
        this.setConfiguration(config);
        this.setTargetComponentName(target);
    }

    @Override
    public boolean isResolved() {
        return this.target != null;
    }

    @Override
    public boolean isDangling() {
        return this.dangling;
    }

    @Override
    public int getSymbolSpace() {
        return 805;
    }

    public void setTargetComponentName(StructuredQName target) {
        this.qName = target;
    }

    @Override
    public StructuredQName getTargetComponentName() {
        return this.qName;
    }

    AttributeWildcard getAttributeWildcard(SchemaCompiler compiler, Stack<AttributeGroupDecl> stack) {
        if (this.target == null) {
            throw new MissingComponentExceptionImpl(this);
        }
        if (stack.contains(this.target)) {
            return null;
        }
        return this.target.getAttributeWildcard(compiler, stack);
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        AttributeGroupDecl decl = (AttributeGroupDecl)PreparedSchema.validateReference(this, compiler, false);
        if (decl == null) {
            this.setFixupStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        this.lookForCycles(new Stack<SchemaComponent>(), compiler);
        this.setFixupStatus(SchemaValidationStatus.VALIDATED);
        this.setValidationStatus(SchemaValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        if (this.getFixupStatus() == SchemaValidationStatus.UNVALIDATED) {
            boolean b = this.fixup(compiler);
            if (b) {
                this.setFixupStatus(SchemaValidationStatus.VALIDATED);
                this.setValidationStatus(SchemaValidationStatus.VALIDATED);
                return true;
            }
            this.setFixupStatus(SchemaValidationStatus.INVALID);
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        if (this.getFixupStatus() == SchemaValidationStatus.INVALID) {
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        this.setValidationStatus(SchemaValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public void lookForCycles(Stack<SchemaComponent> references, SchemaCompiler compiler) throws SchemaException {
        if (compiler.getLanguageVersion() == 11) {
            return;
        }
        try {
            if (references.contains(this)) {
                throw new SchemaException("The definition of attribute group " + Err.wrap(this.getTargetComponentName().getDisplayName()) + " is circular");
            }
            StructuredQName fp = this.getTargetComponentName();
            if (fp == null) {
                return;
            }
            AttributeGroupDecl group = compiler.getPreparedSchema().getAttributeGroup(fp);
            if (group != null) {
                references.push(this);
                group.lookForCycles(references, compiler);
                references.pop();
            }
        }
        catch (SchemaException err) {
            this.setTargetComponentName(StandardNames.SQ_XS_INVALID_NAME);
            throw err;
        }
    }

    @Override
    public void tryToResolve(SchemaCompiler compiler, boolean fatal) throws SchemaException {
        if (!this.dangling) {
            PreparedSchema schema = compiler.getPreparedSchema();
            if (this.target == null) {
                this.target = schema.getAttributeGroup(this.getTargetComponentName());
            }
            if (this.target == null) {
                this.target = this.getConfiguration().getSuperSchema().getAttributeGroup(this.getTargetComponentName());
            }
            if (this.target == null) {
                if (compiler.isAllowDanglingReferences()) {
                    compiler.warning("Unknown attribute group " + this.qName.getEQName() + " (substituting an empty attribute group)", "SXSD1000", this);
                    this.dangling = true;
                    this.target = new AttributeGroupDecl(compiler.getConfiguration());
                    this.target.addAttributeGroupReference(this);
                    this.target.setAttributeGroupName(this.qName);
                } else {
                    throw new SchemaException("Unknown type " + this.qName.getEQName(), this);
                }
            }
        }
    }

    @Override
    public SchemaComponent getTarget() throws MissingComponentException {
        if (this.target == null) {
            throw new MissingComponentExceptionImpl(this);
        }
        return this.target;
    }

    @Override
    public void elaborate(SchemaCompiler compiler) {
    }

    @Override
    public FunctionItem getComponentAsFunction() {
        throw new UnsupportedOperationException();
    }
}

