/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import java.util.HashSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.functions.DistinctValues;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class DuplicateValues
extends CollatingFunctionFixed {
    public static final AtomicMatchKey NaN_MATCH_KEY = DistinctValues.NaN_MATCH_KEY;

    @Override
    public String getStreamerName() {
        return "DistinctValues";
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringCollator collator = this.getStringCollator();
        return new LazySequence(new DuplicatesIterator(arguments[0].iterate(), collator, context));
    }

    public static class DuplicatesIterator
    implements SequenceIterator {
        private final SequenceIterator base;
        private final StringCollator collator;
        private final XPathContext context;
        private final HashSet<AtomicMatchKey> firstValues = new HashSet(40);
        private final HashSet<AtomicMatchKey> secondValues = new HashSet(40);

        public DuplicatesIterator(SequenceIterator base, StringCollator collator, XPathContext context) {
            this.base = base;
            this.collator = collator;
            this.context = context;
        }

        @Override
        public AtomicValue next() {
            AtomicValue nextBase;
            AtomicMatchKey key;
            int implicitTimezone = this.context.getImplicitTimezone();
            do {
                if ((nextBase = (AtomicValue)this.base.next()) == null) {
                    return null;
                }
                if (nextBase.isNaN()) {
                    key = NaN_MATCH_KEY;
                    continue;
                }
                try {
                    key = nextBase.getXPathMatchKey(this.collator, implicitTimezone);
                }
                catch (NoDynamicContextException e) {
                    throw new UncheckedXPathException(e);
                }
            } while (this.firstValues.add(key) || !this.secondValues.add(key));
            return nextBase;
        }

        @Override
        public void close() {
            this.base.close();
        }
    }
}

