/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserSchemaComponent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.om.DocumentKey;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;

public abstract class UserDefinedType
extends SchemaStructure
implements UserSchemaComponent,
SchemaType {
    protected int finalProhibitions = 0;
    private TypeReference baseTypeReference;
    private StructuredQName containingDeclarationName;
    private boolean containingDeclarationIsElementNode = true;
    private int derivation = 1;
    private int fingerprint = -1;
    private StructuredQName qName = null;
    protected Set<UserComplexType> extendedTypes;

    @Override
    public String getName() {
        return this.getTypeName().getLocalPart();
    }

    @Override
    public NamespaceUri getTargetNamespace() {
        return this.getTypeName().getNamespaceUri();
    }

    @Override
    public int getFingerprint() {
        return this.fingerprint;
    }

    public StructuredQName getTypeName() {
        return this.qName;
    }

    @Override
    public StructuredQName getStructuredQName() {
        return this.qName;
    }

    @Override
    public String getEQName() {
        return null;
    }

    @Override
    public boolean isAnonymousType() {
        return this.fingerprint == -1 || this.getTargetNamespace().equals(NamespaceUri.ANONYMOUS);
    }

    public void setTypeName(StructuredQName name, int fingerprint) {
        this.qName = name;
        this.fingerprint = fingerprint;
    }

    public TypeReference getBaseTypeReference() {
        return this.baseTypeReference;
    }

    public int getBaseTypeFingerprint() {
        if (this.baseTypeReference != null) {
            return this.baseTypeReference.getTargetFingerprint();
        }
        return -1;
    }

    @Override
    public String getDisplayName() {
        return this.getTypeName().getDisplayName();
    }

    @Override
    public final boolean isComplexType() {
        return !this.isSimpleType();
    }

    @Override
    public int getBlock() {
        return 0;
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    @Override
    public SchemaType getBaseType() {
        if (this.baseTypeReference == null) {
            if (this.isSimpleType()) {
                return AnySimpleType.getInstance();
            }
            return AnyType.getInstance();
        }
        try {
            return (SchemaType)this.baseTypeReference.getTarget();
        }
        catch (MissingComponentException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setBaseTypeReference(TypeReference baseType) {
        this.baseTypeReference = baseType;
    }

    @Override
    public int getDerivationMethod() {
        return this.derivation;
    }

    @Override
    public boolean allowsDerivation(int derivation) {
        return (this.finalProhibitions & derivation) == 0;
    }

    @Override
    public int getFinalProhibitions() {
        return this.finalProhibitions;
    }

    public void setDerivationMethodName(String method) throws SchemaException {
        switch (method) {
            case "restriction": {
                this.derivation = 1;
                break;
            }
            case "union": {
                this.derivation = 4;
                break;
            }
            case "list": {
                this.derivation = 8;
                break;
            }
            case "extension": {
                this.derivation = 2;
                break;
            }
            default: {
                throw new SchemaException("Unknown derivation method: " + method);
            }
        }
    }

    public void setDerivationMethod(int method) {
        this.derivation = method;
    }

    public void setFinalProhibitions(int finalValue) {
        this.finalProhibitions = finalValue;
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType type, int block) throws SchemaException {
        UserComplexType.checkTypeDerivation((ComplexType)((Object)this), type, block);
    }

    public void setContainingDeclaration(StructuredQName declarationName, boolean isElement) {
        this.containingDeclarationName = declarationName;
        this.containingDeclarationIsElementNode = isElement;
    }

    @Override
    public String getDescription() {
        int fp = this.getFingerprint();
        NamePool pool = this.getNamePool();
        if (fp != -1 && !this.getTypeName().hasURI(NamespaceUri.ANONYMOUS)) {
            return this.getTypeName().getEQName();
        }
        if (this.containingDeclarationName != null) {
            return "of " + (this.containingDeclarationIsElementNode ? "element " : "attribute ") + this.containingDeclarationName.getDisplayName();
        }
        String sysId = this.getSystemId();
        if (sysId == null) {
            return pool.getEQName(fp);
        }
        int lastSlash = sysId.lastIndexOf(47);
        String module = lastSlash < 0 ? sysId : sysId.substring(lastSlash + 1);
        return "at " + module + "#" + this.getLineNumber();
    }

    public String toString() {
        return (this.isComplexType() ? "ComplexType " : "SimpleType ") + this.getDescription();
    }

    public StructuredQName getContainingDeclarationName() {
        return this.containingDeclarationName;
    }

    public boolean containingDeclarationIsElement() {
        return this.containingDeclarationIsElementNode;
    }

    @Override
    public boolean isSameType(SchemaType other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UserDefinedType) {
            UserDefinedType so = (UserDefinedType)other;
            return this.getFingerprint() == other.getFingerprint() && this.hasSameLocation(so);
        }
        return this.getFingerprint() == other.getFingerprint();
    }

    public static boolean isSameURI(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.equals(s2)) {
            return true;
        }
        s1 = DocumentKey.normalizeURI(s1);
        s2 = DocumentKey.normalizeURI(s2);
        return s1.equals(s2);
    }

    protected void registerExtensionType(UserComplexType derived) {
        if (this.extendedTypes == null) {
            this.extendedTypes = new HashSet<UserComplexType>(5);
        }
        this.extendedTypes.add(derived);
    }

    public Set<UserComplexType> getExtensionTypes() {
        if (this.extendedTypes == null) {
            return Collections.emptySet();
        }
        return this.extendedTypes;
    }

    public void setExtendedTypes(Set<UserComplexType> types) {
        this.extendedTypes = types;
    }
}

