/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.AbstractBlockIterator;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;

public class Replicate
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        GroundedValue baseValue = arguments[0].materialize();
        NumericValue n = (NumericValue)arguments[1].head();
        int count = (int)n.longValue();
        if (count < 2) {
            if (count < 0) {
                throw new XPathException("Replication count is negative", "FORG0099");
            }
            if (count == 0) {
                return EmptySequence.getInstance();
            }
            return baseValue;
        }
        return new LazySequence(new RepeatingIterator(baseValue, count, context));
    }

    private static class RepeatingIterator
    extends AbstractBlockIterator {
        private final GroundedValue baseValue;

        public RepeatingIterator(GroundedValue baseValue, int count, XPathContext context) {
            super(count, context);
            this.baseValue = baseValue;
        }

        @Override
        public SequenceIterator getNthChildIterator(int n) {
            return this.baseValue.iterate();
        }
    }
}

