/*
 * Decompiled with CFR 0.152.
 */
package experimental.morfessor;

import experimental.morfessor.Morpheme;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marmot.util.FileUtils;

public class Expander
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern LINE_PATTERN_ = Pattern.compile("^1 (\\*[1-4]?) (.+)$");
    private Map<String, List<Morpheme>> sub_morphs_;

    public Expander(String segmentation_file) {
        this.init(segmentation_file);
    }

    private void init(String segmentation_file) {
        this.sub_morphs_ = new HashMap<String, List<Morpheme>>();
        try {
            BufferedReader reader = FileUtils.openFile(segmentation_file);
            while (reader.ready()) {
                String line = reader.readLine();
                Matcher m4 = LINE_PATTERN_.matcher(line);
                if (!m4.matches()) continue;
                String type = m4.group(1);
                List<Morpheme> morphs = Morpheme.split(m4.group(2));
                this.sub_morphs_.put(Morpheme.join(morphs, false, false, "") + type, morphs);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Morpheme> expand(List<Morpheme> morphs) {
        return this.expand(morphs, false);
    }

    public List<Morpheme> expand(List<Morpheme> morphs, boolean split_all) {
        LinkedList<Morpheme> morph_list = new LinkedList<Morpheme>();
        for (Morpheme morph : morphs) {
            morph_list.addAll(this.expand(morph, split_all));
        }
        ListIterator iterator2 = morph_list.listIterator();
        while (iterator2.hasNext()) {
            Morpheme next_morph;
            Morpheme morph;
            morph = (Morpheme)iterator2.next();
            if (!morph.isNonMorpheme() || !iterator2.hasNext() || !(next_morph = (Morpheme)iterator2.next()).isNonMorpheme()) continue;
            morph.setMorpheme(morph.getMorpheme() + next_morph.getMorpheme());
            morph.setAsterisk(null);
            iterator2.remove();
            iterator2.previous();
        }
        for (Morpheme morph : morph_list) {
            if (!morph.isNonMorpheme()) continue;
            morph.setTag("STM");
        }
        return morph_list;
    }

    public List<Morpheme> expand(Morpheme morph, boolean split_all) {
        if (morph.isNonMorpheme()) {
            return Collections.singletonList(morph);
        }
        List<Morpheme> sub_morphs = this.sub_morphs_.get(morph.getMorphAsterisk());
        if (sub_morphs == null) {
            return Collections.singletonList(morph);
        }
        LinkedList<Morpheme> morph_list = new LinkedList<Morpheme>();
        for (Morpheme sub_morph : sub_morphs) {
            if (sub_morph.isNonMorpheme() && !split_all) {
                return Collections.singletonList(morph);
            }
            morph_list.addAll(this.expand(sub_morph, split_all));
        }
        return morph_list;
    }
}

