/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import lemming.lemma.LemmaCandidateSet;
import lemming.lemma.LemmaError;
import lemming.lemma.LemmaInstance;
import lemming.lemma.Lemmatizer;
import lemming.lemma.LemmatizerGenerator;
import marmot.morph.io.SentenceReader;

public class LemmaResult {
    private int num_tokens_;
    private List<LemmaError> errors_;
    private int num_oov_tokens_;

    public LemmaResult(int num_tokens, int num_oov_tokens, List<LemmaError> errors) {
        this.num_tokens_ = num_tokens;
        this.num_oov_tokens_ = num_oov_tokens;
        this.errors_ = errors;
    }

    public static LemmaResult test(Lemmatizer lemmatizer, String file) {
        return LemmaResult.test(lemmatizer, LemmaInstance.getInstances(new SentenceReader(file)));
    }

    public static LemmaResult test(Lemmatizer lemmatizer, Collection<LemmaInstance> instances) {
        int total = 0;
        int num_oovs = 0;
        LinkedList<LemmaError> errors = new LinkedList<LemmaError>();
        for (LemmaInstance instance : instances) {
            String predicted_lemma = lemmatizer.lemmatize(instance);
            if (lemmatizer.isOOV(instance)) {
                num_oovs = (int)((double)num_oovs + instance.getCount());
            }
            if (predicted_lemma == null || !predicted_lemma.equals(instance.getLemma())) {
                errors.add(new LemmaError(instance, predicted_lemma, lemmatizer.isOOV(instance)));
            }
            total = (int)((double)total + instance.getCount());
        }
        return new LemmaResult(total, num_oovs, errors);
    }

    public static void logTest(Lemmatizer lemmatizer, String file, int limit) {
        LemmaResult result = LemmaResult.test(lemmatizer, file);
        result.logAccuracy();
        result.logErrors(limit);
    }

    private String format(int correct, int total) {
        double acc = (double)correct * 100.0 / (double)total;
        return String.format("%6d / %6d = %g", correct, total, acc);
    }

    public void logAccuracy() {
        int errors = 0;
        int oov_errors = 0;
        for (LemmaError error : this.errors_) {
            errors = (int)((double)errors + error.getInstance().getCount());
            if (!error.isOOV()) continue;
            oov_errors = (int)((double)oov_errors + error.getInstance().getCount());
        }
        int correct = this.num_tokens_ - errors;
        int oov_correct = this.num_oov_tokens_ - oov_errors;
        Logger.getLogger(this.getClass().getName()).info(String.format("%s (OOV: %s)", this.format(correct, this.num_tokens_), this.format(oov_correct, this.num_oov_tokens_)));
    }

    public void logErrors(int limit) {
        StringBuilder sb = new StringBuilder();
        sb.append("Errors:\n");
        int number = 0;
        for (LemmaError error : this.errors_) {
            sb.append(error);
            sb.append('\n');
            if (limit < 0 || ++number < limit) continue;
            break;
        }
        Logger.getLogger(this.getClass().getName()).info(sb.toString());
    }

    public double getTokenAccuracy() {
        int correct = this.num_tokens_;
        for (LemmaError error : this.errors_) {
            correct = (int)((double)correct - error.getInstance().getCount());
        }
        return (double)correct * 100.0 / (double)this.num_tokens_;
    }

    public static LemmaResult testGenerator(LemmatizerGenerator generator, String filename) {
        return LemmaResult.testGenerator(generator, LemmaInstance.getInstances(filename));
    }

    public static LemmaResult testGenerator(LemmatizerGenerator generator, List<LemmaInstance> instances) {
        int total = 0;
        int oov_total = 0;
        LinkedList<LemmaError> errors = new LinkedList<LemmaError>();
        for (LemmaInstance instance : instances) {
            if (generator.isOOV(instance)) {
                oov_total = (int)((double)oov_total + instance.getCount());
            }
            LemmaCandidateSet set = new LemmaCandidateSet();
            generator.addCandidates(instance, set);
            if (!set.contains(instance.getLemma())) {
                errors.add(new LemmaError(instance, null, generator.isOOV(instance)));
            }
            total = (int)((double)total + instance.getCount());
        }
        return new LemmaResult(total, oov_total, errors);
    }
}

