/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.toutanova;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import lemming.lemma.toutanova.Decoder;
import lemming.lemma.toutanova.Result;
import lemming.lemma.toutanova.ToutanovaInstance;
import lemming.lemma.toutanova.ToutanovaModel;

public class ZeroOrderDecoder
implements Decoder {
    private ToutanovaModel model_;
    private double[] score_array_;
    private int[] output_array_;
    private int[] index_array_;
    private int num_output_symbols_;
    private int input_length_;
    private ToutanovaInstance instance_;

    @Override
    public void init(ToutanovaModel model) {
        assert (model != null);
        this.model_ = model;
        this.num_output_symbols_ = this.model_.getOutputTable().size();
    }

    @Override
    public Result decode(ToutanovaInstance instance) {
        int max_input_segment_length = this.model_.getMaxInputSegmentLength();
        this.input_length_ = instance.getFormCharIndexes().length;
        this.instance_ = instance;
        this.checkArraySize(this.input_length_);
        Arrays.fill(this.score_array_, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.output_array_, -1);
        Arrays.fill(this.index_array_, -1);
        for (int l = 1; l < this.input_length_ + 1; ++l) {
            double best_score = Double.NEGATIVE_INFINITY;
            int best_output = -1;
            int best_index = -1;
            for (int o = 0; o < this.num_output_symbols_; ++o) {
                for (int l_start = Math.max(0, l - max_input_segment_length); l_start < l; ++l_start) {
                    double score = this.model_.getPairScore(instance, l_start, l, o);
                    if (l_start > 0) {
                        score += this.score_array_[l_start - 1];
                    }
                    if (!(score > best_score)) continue;
                    best_score = score;
                    best_output = o;
                    best_index = l_start;
                }
            }
            this.score_array_[l - 1] = best_score;
            this.output_array_[l - 1] = best_output;
            this.index_array_[l - 1] = best_index;
        }
        Result result = this.backTrace();
        return result;
    }

    private Result backTrace() {
        LinkedList<Integer> outputs = new LinkedList<Integer>();
        LinkedList<Integer> inputs = new LinkedList<Integer>();
        int end_index = this.input_length_;
        while (true) {
            int start_index = this.index_array_[end_index - 1];
            int output = this.output_array_[end_index - 1];
            inputs.add(end_index);
            outputs.add(output);
            if (start_index == 0) break;
            end_index = start_index;
        }
        Collections.reverse(outputs);
        Collections.reverse(inputs);
        return new Result(this.model_, outputs, inputs, this.instance_.getInstance().getForm(), this.score_array_[this.input_length_ - 1]);
    }

    private void checkArraySize(int required_length) {
        if (this.score_array_ == null || this.score_array_.length < required_length) {
            this.score_array_ = new double[required_length];
            this.output_array_ = new int[this.score_array_.length];
            this.index_array_ = new int[this.score_array_.length];
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

