/*
 * Decompiled with CFR 0.152.
 */
package marmot.core;

import java.io.Serializable;
import java.util.Arrays;

public class Feature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] bytes_;
    private short current_length_;
    private short current_bit_index_;

    public Feature(int[] bytes, short current_length, short current_bit_index) {
        this.bytes_ = bytes;
        this.current_length_ = current_length;
        this.current_bit_index_ = current_bit_index;
    }

    public Feature(int length) {
        this.bytes_ = new int[length];
        this.current_length_ = 0;
        this.current_bit_index_ = (short)32;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes_);
        result = 31 * result + this.current_bit_index_;
        result = 31 * result + this.current_length_;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        if (!Arrays.equals(this.bytes_, other.bytes_)) {
            return false;
        }
        if (this.current_bit_index_ != other.current_bit_index_) {
            return false;
        }
        return this.current_length_ == other.current_length_;
    }

    public int[] getBytes() {
        return this.bytes_;
    }

    public short getCurrentBitIndex() {
        return this.current_bit_index_;
    }

    public short getCurrentLength() {
        return this.current_length_;
    }

    public void setBitIndex(short current_bit_index) {
        this.current_bit_index_ = current_bit_index;
    }

    public void setArrayLength(short current_array_length) {
        this.current_length_ = current_array_length;
    }
}

