/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.toutanova;

import java.io.Serializable;
import lemming.lemma.toutanova.ToutanovaInstance;
import marmot.core.Feature;
import marmot.util.DynamicWeights;
import marmot.util.Encoder;
import marmot.util.SymbolTable;

public abstract class IndexConsumer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SymbolTable<Feature> feature_map_;
    private int num_pos_bits_;
    protected DynamicWeights weights_;

    public abstract void consume(int var1);

    public IndexConsumer(DynamicWeights weights, SymbolTable<Feature> feature_map, int num_pos_bits) {
        this.setWeights(weights);
        this.feature_map_ = feature_map;
        this.num_pos_bits_ = num_pos_bits;
    }

    public void consume(ToutanovaInstance instance, Encoder encoder) {
        int index = this.feature_map_.toIndex(encoder.getFeature(), -1, this.getInsert());
        this.consume(index);
        if (this.num_pos_bits_ >= 0 && instance.getPosTagIndex() >= 0) {
            encoder.storeState();
            encoder.append(instance.getPosTagIndex(), this.num_pos_bits_);
            index = this.feature_map_.toIndex(encoder.getFeature(), -1, this.getInsert());
            this.consume(index);
            encoder.restoreState();
        }
    }

    protected abstract boolean getInsert();

    public void setWeights(DynamicWeights weights) {
        this.weights_ = weights;
    }
}

