/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.validate.AnyTypeValidator;
import com.saxonica.ee.validate.AttributeValidator;
import com.saxonica.ee.validate.ContentValidator;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationFailure;

public class EmptyContentValidator
extends AttributeValidator {
    private final boolean allowTextNodes;
    private Location locationId;
    private UnicodeBuilder buffer;
    private final SchemaType schemaType;

    public EmptyContentValidator(UserComplexType type, Receiver next) throws MissingComponentException {
        super(next);
        this.schemaType = type;
        this.setAttributeGroup(type.getCombinedAttributeGroup());
        this.allowTextNodes = type.isMixedContent();
        this.setAnnotation(type);
    }

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    @Override
    protected ContentValidator getChildValidator() {
        return new AnyTypeValidator(this.getNextReceiver());
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.locationId = location.saveLocation();
        String message = "Invalid child element " + Err.wrap(elemName.getDisplayName(), 1) + ", " + this.getContainingElementName() + " has an empty content model";
        ValidationFailure ve = new ValidationFailure(message);
        ve.setConstraintReference(1, "cvc-complex-type", "2.1");
        ve.setSchemaType(this.getSchemaType());
        this.reportValidationError(ve, true, location);
        this.buffer = null;
        super.startElement(elemName, AnyType.getInstance(), attributes, namespaces, location, properties);
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.checkNoCharactersWhenNil(locationId);
        if (this.allowTextNodes) {
            ElementDecl decl = this.getElementDeclaration();
            if (decl != null && (decl.getFixedValue() != null || decl.getDefaultValueLexicalForm() != null)) {
                if (this.buffer == null) {
                    this.buffer = new UnicodeBuilder();
                }
                this.buffer.accept(chars);
            }
        } else {
            String message = "Character data is not allowed: " + this.getContainingElementName() + " has an empty content model";
            ValidationFailure ve = new ValidationFailure(message);
            ve.setConstraintReference(1, "cvc-complex-type", "2.1");
            ve.setSchemaType(this.getSchemaType());
            this.reportValidationError(ve, true, locationId);
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    @Override
    public void endElement() throws XPathException {
        ElementDecl decl;
        if (this.isNilled() && (decl = this.getElementDeclaration()) != null && decl.getFixedValue() != null) {
            String message = "An element with xsi:nil='true' must not have a fixed value";
            ValidationFailure ve = new ValidationFailure(message);
            ve.setConstraintReference(1, "cvc-elt", "3.2.2");
            ve.setSchemaType(this.getSchemaType());
            this.reportValidationError(ve, true, this.locationId);
        }
        if (this.allowTextNodes && (decl = this.getElementDeclaration()) != null) {
            UnicodeString defaultValue = decl.getDefaultValueLexicalForm();
            UnicodeString fixedValue = decl.getFixedValueLexicalForm();
            if (defaultValue != null && (this.buffer == null || this.buffer.isEmpty())) {
                this.characters(defaultValue, Loc.NONE, 0);
            } else if (fixedValue != null) {
                UnicodeBuilder fsb = this.buffer;
                if (fsb == null || fsb.isEmpty()) {
                    this.characters(fixedValue, Loc.NONE, 0);
                } else if (!fsb.toUnicodeString().equals(fixedValue)) {
                    String message = "The content " + Err.wrap(this.buffer.toString(), 4) + " of " + this.getContainingElementName() + " does not match the fixed value " + Err.wrap(fixedValue, 4);
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-elt", "5.2.2.2");
                    ve.setSchemaType(this.getSchemaType());
                    this.reportValidationError(ve, true, this.getContainingElementLocationId());
                }
            }
        }
        super.endElement();
    }
}

