/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.PendingUpdateAction;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;

public class ReplaceNodeAction
extends PendingUpdateAction {
    private final NodeInfo[] content;
    private final MutableNodeInfo targetNode;
    private final boolean inherit;

    ReplaceNodeAction(NodeInfo[] content, MutableNodeInfo targetNode, boolean inherit) {
        this.content = content;
        this.targetNode = targetNode;
        this.inherit = inherit;
    }

    @Override
    public void apply(XPathContext context, Set<MutableNodeInfo> affectedRootSet) throws XPathException {
        if (!this.targetNode.getTreeInfo().isMutable()) {
            throw new XPathException("Attempting to update a non-updatable element", "SXUP0081");
        }
        NodeInfo root = this.targetNode.getRoot();
        MutableNodeInfo parent = (MutableNodeInfo)this.targetNode.getParent();
        if (!parent.isDeleted() && !this.targetNode.isDeleted()) {
            this.targetNode.replace(this.content, this.inherit);
            affectedRootSet.add((MutableNodeInfo)root);
            parent.removeTypeAnnotation();
        }
    }

    @Override
    public NodeInfo getTargetNode() {
        return this.targetNode;
    }

    public NodeInfo[] getNewContent() {
        return this.content;
    }

    @Override
    public int getApplyPhase() {
        return 3;
    }
}

