/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj;

import com.saxonica.xqj.ObjectConverter;
import com.saxonica.xqj.SaxonXQDataFactory;
import com.saxonica.xqj.SaxonXQItemAccessor;
import com.saxonica.xqj.SaxonXQItemType;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemAccessor;
import javax.xml.xquery.XQItemType;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMObjectModel;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SaxonDuration;
import net.sf.saxon.value.SaxonXMLGregorianCalendar;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import org.w3c.dom.Node;

public class StandardObjectConverter
implements ObjectConverter {
    Configuration config;

    public StandardObjectConverter(SaxonXQDataFactory factory) {
        this.config = factory.getConfiguration();
    }

    @Override
    public Object toObject(XQItemAccessor xqItemAccessor) throws XQException {
        Item item = ((SaxonXQItemAccessor)((Object)xqItemAccessor)).getSaxonItem();
        if (item instanceof AtomicValue) {
            AtomicValue p = (AtomicValue)item;
            int t = p.getItemType().getPrimitiveType();
            switch (t) {
                case 529: {
                    return p.getUnicodeStringValue().toString();
                }
                case 528: {
                    return ((Base64BinaryValue)p).getBinaryValue();
                }
                case 514: {
                    return ((BooleanValue)p).getBooleanValue();
                }
                case 521: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 519: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 515: {
                    return ((DecimalValue)p).getDecimalValue();
                }
                case 517: {
                    return ((DoubleValue)p).getDoubleValue();
                }
                case 518: {
                    return new SaxonDuration((DurationValue)p);
                }
                case 516: {
                    return Float.valueOf(((FloatValue)p).getFloatValue());
                }
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 527: {
                    return ((HexBinaryValue)p).getBinaryValue();
                }
                case 533: {
                    if (p instanceof BigIntegerValue) {
                        return ((BigIntegerValue)p).asBigInteger();
                    }
                    int sub = p.getItemType().getFingerprint();
                    switch (sub) {
                        case 533: 
                        case 534: 
                        case 535: 
                        case 540: 
                        case 541: 
                        case 542: {
                            return BigInteger.valueOf(((Int64Value)p).longValue());
                        }
                        case 539: {
                            return (byte)((Int64Value)p).longValue();
                        }
                        case 537: 
                        case 544: {
                            return (int)((Int64Value)p).longValue();
                        }
                        case 536: 
                        case 543: {
                            return ((Int64Value)p).longValue();
                        }
                        case 538: 
                        case 545: {
                            return (short)((Int64Value)p).longValue();
                        }
                    }
                    throw new XQException("Unrecognized integer subtype " + sub);
                }
                case 530: {
                    return ((QualifiedNameValue)p).toJaxpQName();
                }
                case 513: 
                case 631: {
                    return p.getUnicodeStringValue().toString();
                }
                case 520: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 634: {
                    return new SaxonDuration((DurationValue)p);
                }
                case 633: {
                    return new SaxonDuration((DurationValue)p);
                }
            }
            throw new XQException("unsupported type");
        }
        return NodeOverNodeInfo.wrap((NodeInfo)item);
    }

    @Override
    public Item convertToItem(Object value) throws XQException {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof Boolean) {
                return BooleanValue.get((Boolean)value);
            }
            if (value instanceof byte[]) {
                return new HexBinaryValue((byte[])value);
            }
            if (value instanceof Byte) {
                return new Int64Value(((Byte)value).byteValue(), BuiltInAtomicType.BYTE, false);
            }
            if (value instanceof Float) {
                return new FloatValue(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return new DoubleValue((Double)value);
            }
            if (value instanceof Integer) {
                return new Int64Value(((Integer)value).intValue(), BuiltInAtomicType.INT, false);
            }
            if (value instanceof Long) {
                return new Int64Value((Long)value, BuiltInAtomicType.LONG, false);
            }
            if (value instanceof Short) {
                return new Int64Value(((Short)value).shortValue(), BuiltInAtomicType.SHORT, false);
            }
            if (value instanceof String) {
                return new StringValue((String)value);
            }
            if (value instanceof BigDecimal) {
                return new BigDecimalValue((BigDecimal)value);
            }
            if (value instanceof BigInteger) {
                return new BigIntegerValue((BigInteger)value);
            }
            if (value instanceof SaxonDuration) {
                return ((SaxonDuration)value).getDurationValue();
            }
            if (value instanceof Duration) {
                return DurationValue.makeDuration(StringView.of(value.toString()).tidy()).asAtomic();
            }
            if (value instanceof SaxonXMLGregorianCalendar) {
                return ((SaxonXMLGregorianCalendar)value).toCalendarValue();
            }
            if (value instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar g = (XMLGregorianCalendar)value;
                QName gtype = g.getXMLSchemaType();
                UnicodeString gregVal = StringView.of(value.toString()).tidy();
                if (gtype.equals(DatatypeConstants.DATETIME)) {
                    return DateTimeValue.makeDateTimeValue(gregVal, this.config.getConversionRules()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.DATE)) {
                    return DateValue.makeDateValue(gregVal, this.config.getConversionRules()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.TIME)) {
                    return TimeValue.makeTimeValue(gregVal).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GYEAR)) {
                    return GYearValue.makeGYearValue(gregVal, this.config.getConversionRules()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GYEARMONTH)) {
                    return GYearMonthValue.makeGYearMonthValue(gregVal, this.config.getConversionRules()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GMONTH)) {
                    return GMonthValue.makeGMonthValue(gregVal).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GMONTHDAY)) {
                    return GMonthDayValue.makeGMonthDayValue(gregVal).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GDAY)) {
                    return GDayValue.makeGDayValue(gregVal).asAtomic();
                }
                throw new AssertionError((Object)"Unknown Gregorian date type");
            }
            if (value instanceof QName) {
                QName q = (QName)value;
                return new QNameValue(q.getPrefix(), NamespaceUri.of(q.getNamespaceURI()), q.getLocalPart(), BuiltInAtomicType.QNAME, false);
            }
            if (value instanceof Node) {
                JPConverter jp = DOMObjectModel.getInstance().getJPConverter(Node.class, this.config);
                return SequenceTool.asItem(jp.convert(value, new EarlyEvaluationContext(this.config)));
            }
            if (value instanceof Source) {
                PipelineConfiguration pipe = this.config.makePipelineConfiguration();
                TinyBuilder b = new TinyBuilder(pipe);
                b.setStatistics(this.config.getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
                Sender.send((Source)value, b, null);
                NodeInfo node = b.getCurrentRoot();
                b.reset();
                return node;
            }
            if (value instanceof XMLStreamReader) {
                PipelineConfiguration pipe = this.config.makePipelineConfiguration();
                TinyBuilder b = new TinyBuilder(pipe);
                b.setStatistics(this.config.getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
                Sender.send(new StAXSource((XMLStreamReader)value), b, null);
                NodeInfo node = b.getCurrentRoot();
                b.reset();
                return node;
            }
            throw new XPathException("Java object cannot be converted to an XQuery value");
        }
        catch (XPathException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
    }

    @Override
    public Item convertToItem(Object value, XQItemType type) throws XQException {
        if (value == null) {
            return null;
        }
        if (((SaxonXQItemType)type).getSaxonItemType() instanceof JavaExternalObjectType) {
            ObjectValue<Object> result = new ObjectValue<Object>(value);
            if (((SaxonXQItemType)type).getSaxonItemType().matches(result, this.config.getTypeHierarchy())) {
                return result;
            }
            throw new XQException("The result of wrapping an object of class " + value.getClass().getName() + " does not match the required type " + type);
        }
        throw new XQException("Supplied Java object cannot be converted to an XQItem");
    }
}

