/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.UserSchemaComponent;
import com.saxonica.ee.schema.Wildcard;
import net.sf.saxon.om.Function;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;

public class AttributeWildcard
extends SchemaStructure
implements UserSchemaComponent {
    private Wildcard wildcard;

    public AttributeWildcard(EnterpriseConfiguration config) {
        this.wildcard = new Wildcard();
        this.wildcard.setConfiguration(config);
        this.setConfiguration(config);
    }

    public AttributeWildcard(Wildcard wc) {
        this.wildcard = wc;
        this.setConfiguration(wc.getConfiguration());
    }

    public void setWildcard(Wildcard wildcard) {
        this.wildcard = wildcard;
    }

    public Wildcard getWildcard() {
        return this.wildcard;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        if (!this.wildcard.validate(compiler)) {
            return false;
        }
        if (this.wildcard.isInexpressible()) {
            compiler.error("The intersection or union of this wildcard with other wildcards is inexpressible", this);
            return false;
        }
        return true;
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this.wildcard, false);
        serializer.startElement("attributeWildcard");
        serializer.emitAttribute("ref", id);
        serializer.endElement();
    }

    @Override
    public Function getComponentAsFunction() {
        return this.wildcard.getComponentAsFunction();
    }

    @Override
    public SchemaComponent.ValidationStatus getValidationStatus() {
        return SchemaComponent.ValidationStatus.UNVALIDATED;
    }
}

