/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.FilteringAdjunct;
import com.saxonica.ee.stream.feed.BufferingFilterExpressionFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.FilteringFeed;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.BasePatternWithPredicate;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.TypeHierarchy;

public class FilterExpressionAdjunct
extends FilteringAdjunct {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        FilterExpression exp = (FilterExpression)this.getExpression();
        Expression start = exp.getSelectExpression();
        Expression filter = exp.getActionExpression();
        PostureAndSweep startPS = Streamability.getStreamability(start, contextInfo, reasons);
        ContextItemStaticInfoEE info = new ContextItemStaticInfoEE(start.getItemType(), false, startPS.getPosture());
        PostureAndSweep filterPS = Streamability.getStreamability(filter, info, reasons);
        if (filterPS.getSweep() == Sweep.MOTIONLESS) {
            return startPS;
        }
        if (reasons != null) {
            reasons.add("Predicate [" + filter.toShortString() + "] at line " + filter.getLocation().getLineNumber() + " is not motionless");
        }
        return PostureAndSweep.ROAMING_AND_FREE_RANGING;
    }

    @Override
    public Pattern toStreamingPattern(Configuration config) {
        FilterExpression exp = (FilterExpression)this.getExpression();
        TypeHierarchy th = config.getTypeHierarchy();
        Expression base = exp.getSelectExpression();
        Expression filter = exp.getFilter();
        PostureAndSweep fs = Streamability.getStreamability(filter, ContextItemStaticInfoEE.DEFAULT, null);
        if (fs.getSweep() != Sweep.MOTIONLESS) {
            return null;
        }
        Pattern basePattern = Streamability.toStreamingPattern(base, config);
        if (basePattern == null) {
            return null;
        }
        if (exp.isPositional(th)) {
            return null;
        }
        if (ExpressionTool.containsLocalVariableReference(exp)) {
            return null;
        }
        return new BasePatternWithPredicate(basePattern, filter);
    }

    @Override
    public FilteringFeed.Filter makeFilter(XPathContext context, Feed out) {
        return new PredicateFilter(((FilterExpression)this.getExpression()).getActionExpression(), context);
    }

    @Override
    public FeedMaker getFeedMaker(int arg) throws XPathException {
        boolean isBuffering;
        FilterExpression f = (FilterExpression)this.getExpression();
        boolean bl = isBuffering = (f.getActionExpression().getDependencies() & 8) != 0;
        if (isBuffering) {
            return (watchManager, out, context) -> new BufferingFilterExpressionFeed(this.getExpression(), out, context);
        }
        return super.getFeedMaker(arg);
    }

    private static class PredicateFilter
    implements FilteringFeed.Filter {
        private Expression predicate;
        private XPathContext context;
        private ManualIterator iter;

        public PredicateFilter(Expression predicate, XPathContext context) {
            this.predicate = predicate;
            this.context = context.newMinorContext();
            this.iter = new ManualIterator();
            this.context.setCurrentIterator(this.iter);
        }

        @Override
        public int matches(Item item, int position) throws XPathException {
            this.iter.setContextItem(item);
            this.iter.setPosition(position);
            SequenceIterator<?> predicateValue = this.predicate.iterate(this.context);
            boolean matches = FilterIterator.testPredicateValue(predicateValue, position, this.predicate);
            return matches ? 1 : 0;
        }
    }
}

