/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.style;

import com.saxonica.xsltextn.instruct.Assign;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class SaxonAssign
extends XSLGeneralVariable {
    private Assign instruction;
    private SequenceType requiredType;
    private SourceBinding sourceBinding = new SourceBinding(this);
    private static final int allowedAttributes = 128;

    @Override
    protected void prepareAttributes() throws XPathException {
        this.sourceBinding.prepareAttributes(128);
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        XSLGlobalVariable sourceVar;
        GlobalVariable compiledVar;
        SourceBinding globalVariable;
        super.validate(decl);
        this.instruction = new Assign(this.makeExpression("()", -1));
        this.getConfiguration().checkLicensedFeature(8, "saxon:assign", this.getPackageData().getLocalLicenseId());
        if (this.getConfiguration().getBooleanProperty(Feature.ALLOW_MULTITHREADING)) {
            this.compileWarning("saxon:assign should not be used in a configuration that allows multi-threading: see FeatureKeys.ALLOW_MULTITHREADING", "SXWN9016");
        }
        StructuredQName name = this.getSourceBinding().getVariableQName();
        try {
            globalVariable = this.bindVariable(name);
            if (globalVariable == null) {
                XPathException err = new XPathException("Variable " + name.getDisplayName() + " has not been declared");
                err.setErrorCode("XPST0008");
                err.setIsStaticError(true);
                throw err;
            }
            globalVariable.registerReference(this.instruction);
            this.requiredType = globalVariable.getDeclaredType();
        }
        catch (XPathException err) {
            this.compileError(err.getMessage());
            return;
        }
        if (!globalVariable.hasProperty(2)) {
            this.compileError("Variable " + name.getDisplayName() + " is not global");
            return;
        }
        if (!globalVariable.hasProperty(64)) {
            this.compileError("Variable " + name.getDisplayName() + " is not marked as assignable");
        }
        if ((compiledVar = (sourceVar = (XSLGlobalVariable)globalVariable.getSourceElement()).getCompiledVariable()) != null) {
            this.instruction.fixup(sourceVar.getCompiledVariable());
        }
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.sourceBinding.getSelectExpression() != null) {
            this.instruction.setSelectExpr(this.sourceBinding.getSelectExpression());
        } else {
            this.instruction.setSelectExpr(this.compileSequenceConstructor(exec, decl, false));
        }
        return this.instruction;
    }
}

