/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.ids_mannheim.korap.response.Message;
import de.ids_mannheim.korap.response.Messages;
import de.ids_mannheim.korap.util.KrillString;
import de.ids_mannheim.korap.util.QueryException;
import java.util.Arrays;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Notifications {
    protected ObjectMapper mapper = new ObjectMapper();
    private Messages warnings;
    private Messages errors;
    private Messages messages;

    public boolean hasWarnings() {
        return this.warnings != null && this.warnings.size() != 0;
    }

    @JsonIgnore
    public Messages getWarnings() {
        return this.warnings;
    }

    public Notifications setWarnings(JsonNode msgs) {
        for (JsonNode msg : msgs) {
            this.addWarning(msg);
        }
        return this;
    }

    @JsonIgnore
    public Message getWarning(int index) {
        if (this.warnings != null) {
            return this.warnings.get(index);
        }
        return null;
    }

    public Notifications addWarning(int code, String msg, String ... terms) {
        if (this.warnings == null) {
            this.warnings = new Messages();
        }
        this.warnings.add(code, msg, terms);
        return this;
    }

    public Notifications addWarning(JsonNode node) {
        if (this.warnings == null) {
            this.warnings = new Messages();
        }
        try {
            this.warnings.add(node);
        }
        catch (QueryException qe) {
            this.warnings.add(qe.getErrorCode(), qe.getMessage(), new String[0]);
        }
        return this;
    }

    public Notifications addWarnings(Messages msgs) {
        if (this.warnings == null) {
            this.warnings = msgs;
        } else {
            this.warnings.add(msgs);
        }
        return this;
    }

    @JsonIgnore
    public Messages getErrors() {
        return this.errors;
    }

    public Notifications setErrors(JsonNode msgs) {
        for (JsonNode msg : msgs) {
            this.addError(msg);
        }
        return this;
    }

    @JsonIgnore
    public Message getError(int index) {
        if (this.errors != null) {
            return this.errors.get(index);
        }
        return null;
    }

    public boolean hasErrors() {
        return this.errors != null && this.errors.size() != 0;
    }

    public Notifications addError(int code, String msg, String ... terms) {
        if (this.errors == null) {
            this.errors = new Messages();
        }
        this.errors.add(code, msg, terms);
        return this;
    }

    public Notifications addError(int code, String[] terms) {
        if (this.errors == null) {
            this.errors = new Messages();
        }
        this.errors.add(code, terms[0], Arrays.copyOfRange(terms, 1, terms.length));
        return this;
    }

    public Notifications addError(JsonNode msg) {
        if (this.errors == null) {
            this.errors = new Messages();
        }
        try {
            this.errors.add(msg);
        }
        catch (QueryException qe) {
            this.errors.add(qe.getErrorCode(), qe.getMessage(), new String[0]);
        }
        return this;
    }

    public Notifications addErrors(Messages msgs) {
        if (this.errors == null) {
            this.errors = msgs;
        } else {
            this.errors.add(msgs);
        }
        return this;
    }

    @JsonIgnore
    public Messages getMessages() {
        return this.messages;
    }

    public Notifications setMessages(JsonNode msgs) {
        for (JsonNode msg : msgs) {
            this.addMessage(msg);
        }
        return this;
    }

    @JsonIgnore
    public Message getMessage(int index) {
        if (this.messages != null) {
            return this.messages.get(index);
        }
        return null;
    }

    public boolean hasMessages() {
        return this.messages != null && this.messages.size() != 0;
    }

    public Notifications addMessage(int code, String msg, String ... terms) {
        if (this.messages == null) {
            this.messages = new Messages();
        }
        this.messages.add(code, msg, terms);
        return this;
    }

    public Notifications addMessage(JsonNode msg) {
        if (this.messages == null) {
            this.messages = new Messages();
        }
        try {
            this.messages.add(msg);
        }
        catch (QueryException qe) {
            this.messages.add(qe.getErrorCode(), qe.getMessage(), new String[0]);
        }
        return this;
    }

    public Notifications addMessages(Messages msgs) {
        if (this.messages == null) {
            this.messages = msgs;
        } else {
            this.messages.add(msgs);
        }
        return this;
    }

    public Notifications copyNotificationsFrom(Notifications notes) {
        try {
            if (notes.hasErrors()) {
                this.addErrors((Messages)notes.getErrors().clone());
            }
            if (notes.hasWarnings()) {
                this.addWarnings((Messages)notes.getWarnings().clone());
            }
            if (notes.hasMessages()) {
                this.addMessages((Messages)notes.getMessages().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return this;
    }

    public Notifications copyNotificationsFrom(JsonNode request) {
        JsonNode msgs;
        if (request.has("warnings") && request.get("warnings").isArray()) {
            msgs = request.get("warnings");
            for (JsonNode msg : msgs) {
                this.addWarning(msg);
            }
        }
        if (request.has("messages") && request.get("messages").isArray() && (msgs = request.get("messages")).isArray()) {
            for (JsonNode msg : msgs) {
                this.addMessage(msg);
            }
        }
        if (request.has("errors") && request.get("errors").isArray() && (msgs = request.get("errors")).isArray()) {
            for (JsonNode msg : msgs) {
                this.addError(msg);
            }
        }
        return this;
    }

    public Notifications moveNotificationsFrom(Notifications notes) {
        this.copyNotificationsFrom(notes);
        notes.clearNotifications();
        return this;
    }

    public Notifications clearNotifications() {
        if (this.warnings != null) {
            this.warnings.clear();
        }
        if (this.messages != null) {
            this.messages.clear();
        }
        if (this.errors != null) {
            this.errors.clear();
        }
        return this;
    }

    public JsonNode toJsonNode() {
        ObjectNode json = this.mapper.createObjectNode();
        if (this.hasWarnings()) {
            json.set("warnings", this.getWarnings().toJsonNode());
        }
        if (this.hasErrors()) {
            json.set("errors", this.getErrors().toJsonNode());
        }
        if (this.hasMessages()) {
            json.set("messages", this.getMessages().toJsonNode());
        }
        return json;
    }

    public String toJsonString() {
        Object msg = "";
        try {
            JsonNode node = this.toJsonNode();
            if (node == null) {
                return "{}";
            }
            return this.mapper.writeValueAsString(node);
        }
        catch (Exception e) {
            msg = ", " + KrillString.quote(e.getLocalizedMessage());
            return "{\"errors\" : [[620, \"Unable to generate JSON\"" + (String)msg + "]]}";
        }
    }
}

