/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import marmot.util.SerialUtils;
import org.junit.Assert;
import org.junit.Test;

public class SerialUtilsTest {
    void roundTripTest(double[] expected, double eps, double delta) {
        double[] actual;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            SerialUtils.writeSparseArray(oos, expected, eps);
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] array = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(array);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            actual = SerialUtils.readSparseArray(ois);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertArrayEquals((double[])expected, (double[])actual, (double)delta);
    }

    @Test
    public void trivialTest() {
        double eps;
        double delta = eps = 1.0E-10;
        double[] expected = null;
        this.roundTripTest(expected, eps, delta);
        expected = new double[]{};
        this.roundTripTest(expected, eps, delta);
    }

    @Test
    public void normalTest() {
        double eps = 0.01;
        double delta = 0.1;
        double[] expected = new double[]{1.0, 0.0, 1.0, 0.0, 0.5, 0.11, 0.01, 0.001};
        this.roundTripTest(expected, eps, delta);
    }

    @Test
    public void bigTest() {
        double[] expected = new double[10000000];
        Random random = new Random(42L);
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = random.nextGaussian();
        }
        double eps = 0.01;
        double delta = 0.1;
        this.roundTripTest(expected, eps, delta);
    }

    @Test
    public void zeroOffsetTest() {
        double[] expected = new double[]{1.0, 0.0, 0.0, 0.0};
        double eps = 0.01;
        double delta = 0.1;
        this.roundTripTest(expected, eps, delta);
    }

    @Test
    public void bigOffsetTest() {
        double[] expected = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        double eps = 0.01;
        double delta = 0.1;
        this.roundTripTest(expected, eps, delta);
    }
}

