/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.ComplexNodeEventFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Copy;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;

public class CopyAdjunct
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new CopyFeed(watchManager, (Copy)this.getExpression(), out, context);
    }

    private static class CopyFeed
    extends ComplexNodeEventFeed {
        WatchManager watchManager;
        XPathContext context;
        int nodeKind;
        Receiver receiver;

        public CopyFeed(WatchManager watchManager, Copy expression, Feed result, XPathContext context) throws XPathException {
            super(expression, result, context);
            this.watchManager = watchManager;
        }

        @Override
        protected void processLeft(XPathContext context) throws XPathException {
            Item<?> item = context.getContextItem();
            Copy expression = (Copy)this.getExpression();
            if (item instanceof FleetingParentNode) {
                NodeInfo node = (NodeInfo)item;
                this.nodeKind = node.getNodeKind();
                switch (this.nodeKind) {
                    case 9: {
                        this.receiver = this.getResult().getReceiver();
                        int properties = 0;
                        if (!expression.isPreservingTypes()) {
                            Controller controller = context.getController();
                            Configuration config = controller.getConfiguration();
                            ParseOptions options = new ParseOptions(expression.getValidationOptions());
                            options.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
                            this.receiver = new TreeReceiver(config.getDocumentValidator(this.receiver, node.getBaseURI(), options, expression.getLocation()));
                        } else if (!(this.receiver instanceof TreeReceiver)) {
                            this.receiver = new TreeReceiver(this.receiver);
                        }
                        this.receiver.startDocument(properties);
                        break;
                    }
                    case 1: {
                        NodeName elemName = NameOfNode.makeName(node);
                        Enum typeCode = expression.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
                        int properties = expression.isInheritNamespacesToChildren() ? 0 : 128;
                        this.receiver = this.getResult().getReceiver();
                        if (!expression.isPreservingTypes()) {
                            Controller controller = context.getController();
                            assert (controller != null);
                            ParseOptions options = new ParseOptions(expression.getValidationOptions());
                            options.setTopLevelElement(elemName.getStructuredQName());
                            try {
                                this.receiver = context.getConfiguration().getElementValidator(this.receiver, options, expression.getLocation());
                            }
                            catch (ValidationException e) {
                                this.dynamicError(e);
                            }
                        }
                        if (!(this.receiver instanceof TreeReceiver)) {
                            this.receiver = new TreeReceiver(this.receiver);
                        }
                        if (this.receiver.getSystemId() == null) {
                            this.receiver.setSystemId(expression.getNewBaseURI(context, node));
                        }
                        this.receiver.startElement(elemName, (SchemaType)((Object)typeCode), expression.getLocation(), properties);
                        expression.outputNamespaceNodes(context, this.receiver, elemName, node);
                        break;
                    }
                    default: {
                        try {
                            for (TailCall tc = expression.processLeavingTail(context, node); tc != null; tc = tc.processLeavingTail()) {
                            }
                            break;
                        }
                        catch (XPathException err) {
                            err.maybeSetLocation(expression.getLocation());
                            throw err;
                        }
                    }
                }
            }
        }

        @Override
        protected void processRight(XPathContext context) throws XPathException {
            try {
                if (this.nodeKind == 9) {
                    this.receiver.endDocument();
                } else if (this.nodeKind == 1) {
                    this.receiver.endElement();
                }
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            return null;
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (!this.hasFailed()) {
                if (this.receiver == null) {
                    this.receiver = this.getResult().getReceiver();
                }
                try {
                    this.receiver.append(item);
                }
                catch (XPathException e) {
                    this.dynamicError(e);
                }
            }
        }

        @Override
        public Receiver getReceiver() {
            return this.receiver;
        }
    }
}

