/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.xsltextn.pedigree.PedigreeArrayItem;
import com.saxonica.xsltextn.pedigree.PedigreeMapItem;
import com.saxonica.xsltextn.pedigree.PedigreeValue;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceExtent;

public class MapSearch
extends SystemFunction {
    @Override
    public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
        ArrayList<Item> result = new ArrayList<Item>();
        AtomicValue key = (AtomicValue)arguments[1].head();
        Function tester = arguments.length > 2 ? (Function)arguments[2].head() : null;
        this.processSequence(arguments[0].materialize(), key, tester, context, result);
        return SequenceExtent.makeSequenceExtent(result);
    }

    private void processSequence(GroundedValue<?> seq, AtomicValue key, Function tester, XPathContext context, List<Item> result) throws XPathException {
        Object item;
        GroundedValue in = seq.materialize();
        SequenceIterator iter = in.iterate();
        boolean i = false;
        while ((item = iter.next()) != null) {
            GroundedValue<?> value;
            if (item instanceof ArrayItem) {
                ArrayItem array = (ArrayItem)item;
                if (!(array instanceof PedigreeValue)) {
                    array = new PedigreeArrayItem(array);
                }
                boolean j = false;
                for (GroundedValue<?> member : array.members()) {
                    this.processSequence(member, key, tester, context, result);
                }
                continue;
            }
            if (!(item instanceof MapItem)) continue;
            MapItem map = (MapItem)item;
            if (!(map instanceof PedigreeValue)) {
                map = new PedigreeMapItem(map);
            }
            if ((value = map.get(key)) != null) {
                BooleanValue test;
                Sequence<AtomicValue> sequence = test = tester == null ? BooleanValue.TRUE : tester.call(context, new Sequence[]{value});
                if (((BooleanValue)test.head()).getBooleanValue()) {
                    DictionaryMap hit = new DictionaryMap();
                    hit.initialPut("key", key);
                    hit.initialPut("value", value);
                    hit.initialPut("map", map);
                    result.add(hit);
                }
            }
            for (KeyValuePair entry : map.keyValuePairs()) {
                this.processSequence(entry.value, key, tester, context, result);
            }
        }
    }
}

