/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.jaxp;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.jaxp.SchemaFactoryImpl;
import com.saxonica.ee.jaxp.URIResourceResolver;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.sdoc.LSSchemaResolver;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.validation.Validator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Sink;
import net.sf.saxon.lib.Invalidity;
import net.sf.saxon.lib.InvalidityHandler;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class ValidatorImpl
extends Validator {
    private PipelineConfiguration pipe;

    public ValidatorImpl(PipelineConfiguration pipe, PreparedSchema schema) {
        try {
            this.pipe = pipe;
            EnterpriseConfiguration config = (EnterpriseConfiguration)pipe.getConfiguration();
            config.addSchema(schema);
            this.setErrorHandler(null);
        }
        catch (SchemaException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void validate(Source source, Result result) throws SAXException, IOException {
        try {
            Receiver out;
            if (result == null) {
                out = new Sink(this.pipe);
            } else {
                SerializerFactory sf = this.pipe.getConfiguration().getSerializerFactory();
                out = sf.getReceiver(result, new SerializationProperties(), this.pipe);
            }
            ParseOptions options = this.pipe.getParseOptions();
            options.setSchemaValidationMode(1);
            options.setContinueAfterValidationErrors(true);
            this.pipe.setErrorListener(new SchemaFactoryImpl.ErrorListenerWrappingErrorHandler(this.getErrorHandler()));
            Sender.send(source, out, options);
        }
        catch (TransformerException e) {
            if (e.getException() instanceof SAXException) {
                throw (SAXException)e.getException();
            }
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw new SAXException(e);
        }
        catch (UncheckedXPathException e) {
            XPathException xe = e.getXPathException();
            if (xe.getCause() instanceof SAXException) {
                throw (SAXException)xe.getCause();
            }
            throw new SAXException(xe);
        }
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = SchemaFactoryImpl.DRACONIAN_ERROR_HANDLER;
        }
        InvalidityHandlerWrappingErrorHandler handler = new InvalidityHandlerWrappingErrorHandler(errorHandler);
        this.pipe.getParseOptions().setInvalidityHandler(handler);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        InvalidityHandler handler = this.pipe.getParseOptions().getInvalidityHandler();
        if (handler instanceof InvalidityHandlerWrappingErrorHandler) {
            return ((InvalidityHandlerWrappingErrorHandler)handler).getErrorHandler();
        }
        UnfailingErrorListener listener = this.pipe.getErrorListener();
        if (listener instanceof SchemaFactoryImpl.ErrorListenerWrappingErrorHandler) {
            ErrorHandler eh = ((SchemaFactoryImpl.ErrorListenerWrappingErrorHandler)((Object)listener)).getErrorHandler();
            return eh == SchemaFactoryImpl.DRACONIAN_ERROR_HANDLER ? null : eh;
        }
        return null;
    }

    @Override
    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.pipe.setURIResolver(new URIResourceResolver(resourceResolver));
        this.pipe.setSchemaURIResolver(new LSSchemaResolver(resourceResolver, this.pipe.getConfiguration()));
    }

    @Override
    public LSResourceResolver getResourceResolver() {
        URIResolver u = this.pipe.getURIResolver();
        if (u instanceof URIResourceResolver) {
            return ((URIResourceResolver)u).getLSResourceResolver();
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.pipe.getConfiguration();
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        switch (name) {
            case "http://javax.xml.XMLConstants/feature/secure-processing": 
            case "http://javax.xml.XMLConstants/property/accessExternalDTD": 
            case "http://javax.xml.XMLConstants/property/accessExternalSchema": {
                return this.pipe.getParseOptions().getParserProperty(name);
            }
        }
        try {
            return this.pipe.getConfiguration().getConfigurationProperty(name);
        }
        catch (IllegalArgumentException err) {
            throw new SAXNotSupportedException(err.getMessage());
        }
    }

    @Override
    public void setProperty(String name, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        switch (name) {
            case "http://javax.xml.XMLConstants/feature/secure-processing": 
            case "http://javax.xml.XMLConstants/property/accessExternalDTD": {
                this.pipe.getParseOptions().addParserProperties(name, object);
                break;
            }
            case "http://javax.xml.XMLConstants/property/accessExternalSchema": {
                throw new SAXNotSupportedException();
            }
            default: {
                try {
                    this.pipe.getConfiguration().setConfigurationProperty(name, object);
                    break;
                }
                catch (IllegalArgumentException err) {
                    throw new SAXNotSupportedException(err.getMessage());
                }
            }
        }
    }

    public class InvalidityHandlerWrappingErrorHandler
    implements InvalidityHandler {
        private ErrorHandler errorHandler;

        public InvalidityHandlerWrappingErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        @Override
        public void startReporting(String systemId) throws XPathException {
        }

        @Override
        public void reportInvalidity(Invalidity failure) throws XPathException {
            try {
                ValidationException exception = ((ValidationFailure)failure).makeException();
                this.errorHandler.error(new SAXParseException(failure.getMessage(), exception.getLocator(), exception));
            }
            catch (SAXException e) {
                throw XPathException.makeXPathException(e);
            }
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        @Override
        public Sequence<?> endReporting() {
            return null;
        }
    }
}

