/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config.pe;

import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.trans.XSLArray;
import com.saxonica.trans.XSLArrayMember;
import com.saxonica.xsltextn.ExtensionElementCreator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.style.XSLSwitch;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeFactory;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.SchemaType;

public class StyleNodeFactoryPE
extends StyleNodeFactory
implements NodeFactory {
    protected boolean allowExtensions;

    public StyleNodeFactoryPE(Configuration config, Compilation compilation) {
        super(config, compilation);
        this.allowExtensions = config.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS);
    }

    @Override
    public ElementImpl makeElementNode(NodeInfo parent, NodeName elementName, SchemaType elementType, boolean isNilled, AttributeMap attlist, NamespaceMap namespaces, PipelineConfiguration pipe, Location location, int sequence) {
        StyleElement temp;
        boolean toplevel = parent instanceof XSLModuleRoot;
        if (elementName.hasURI(NamespaceUri.XSLT) || !this.allowExtensions || parent instanceof DataElement) {
            return super.makeElementNode(parent, elementName, elementType, isNilled, attlist, namespaces, pipe, location, sequence);
        }
        StyleElement extensionElement = null;
        NamespaceUri uri = elementName.getNamespaceUri();
        ExtensionElementCreator eef = ((ProfessionalConfiguration)this.config).getExtensionElementCreator(uri);
        if (eef != null) {
            String localName = elementName.getLocalPart();
            extensionElement = eef.createExtensionElement(localName);
        }
        if (extensionElement == null) {
            ElementImpl instr = super.makeElementNode(parent, elementName, elementType, isNilled, attlist, namespaces, pipe, location, sequence);
            if (instr instanceof StyleElement) {
                ((StyleElement)instr).setCompilation(this.getCompilation());
            }
            return instr;
        }
        String baseURI = null;
        int lineNumber = -1;
        int columnNumber = -1;
        baseURI = location.getSystemId();
        lineNumber = location.getLineNumber();
        columnNumber = location.getColumnNumber();
        String localname = elementName.getLocalPart();
        if (this.allowExtensions) {
            temp = extensionElement;
            temp.setCompilation(this.getCompilation());
        } else {
            temp = new AbsentExtensionElement();
            XmlProcessingIncident reason = new XmlProcessingIncident("Extension instructions are disabled");
            temp.setValidationError(reason, StyleElement.OnFailure.REPORT_IF_INSTANTIATED);
        }
        temp.setNamespaceMap(namespaces);
        temp.initialise(elementName, elementType, attlist, parent, sequence);
        temp.setLocation(baseURI, lineNumber, columnNumber);
        temp.processStandardAttributes(NamespaceUri.XSLT);
        if (uri.equals(NamespaceUri.SAXON) && !toplevel && !temp.isExtensionNamespace(NamespaceUri.SAXON)) {
            XmlProcessingIncident te = new XmlProcessingIncident("saxon:" + localname + " is not being treated as an extension instruction because the namespace  http://saxon.sf.net/ has not been declared in extension-element-prefixes", "SXWN9008", temp).asWarning();
            pipe.getErrorReporter().report(te);
            temp = new LiteralResultElement();
        }
        return temp;
    }

    @Override
    protected StyleElement makeXSLElement(int f, NodeImpl parent) {
        if (this.getCompilation().getCompilerInfo().getXsltVersion() >= 40) {
            switch (f) {
                case 134: {
                    return new XSLArray();
                }
                case 135: {
                    return new XSLArrayMember();
                }
                case 209: {
                    return new XSLSwitch();
                }
            }
        }
        return super.makeXSLElement(f, parent);
    }

    @Override
    public boolean isElementAvailable(NamespaceUri uri, String localName, boolean instructionsOnly) {
        boolean b = super.isElementAvailable(uri, localName, instructionsOnly);
        if (b) {
            return true;
        }
        if (!this.allowExtensions) {
            return false;
        }
        ExtensionElementCreator factory = ((ProfessionalConfiguration)this.config).getExtensionElementCreator(uri);
        if (factory == null) {
            return false;
        }
        try {
            StyleElement s = factory.createExtensionElement(localName);
            return !instructionsOnly || s.isInstruction();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public AccumulatorRegistry makeAccumulatorManager() {
        return new AccumulatorRegistry();
    }
}

