/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.PendingUpdateAction;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;

public class InsertAction
extends PendingUpdateAction {
    private final NodeInfo[] content;
    private final MutableNodeInfo targetNode;
    private final int position;
    private final boolean inheritNamespaces;

    public InsertAction(NodeInfo[] content, MutableNodeInfo targetNode, int position, boolean inherit) {
        this.content = content;
        this.targetNode = targetNode;
        this.position = position;
        this.inheritNamespaces = inherit;
    }

    @Override
    public void apply(XPathContext context, Set<MutableNodeInfo> affectedRootSet) throws XPathException {
        if (!this.targetNode.getTreeInfo().isMutable()) {
            throw new XPathException("Attempting to update a non-updatable element", "SXUP0081");
        }
        boolean affectsType = false;
        for (NodeInfo node : this.content) {
            int kind = node.getNodeKind();
            if (kind != 1 && kind != 3) continue;
            affectsType = true;
            break;
        }
        switch (this.position) {
            case 131: {
                this.targetNode.insertChildren(this.content, true, this.inheritNamespaces);
                if (!affectsType) break;
                this.targetNode.removeTypeAnnotation();
                break;
            }
            case 132: 
            case 135: {
                this.targetNode.insertChildren(this.content, false, this.inheritNamespaces);
                if (!affectsType) break;
                this.targetNode.removeTypeAnnotation();
                break;
            }
            case 134: {
                this.targetNode.insertSiblings(this.content, true, this.inheritNamespaces);
                if (!affectsType) break;
                ((MutableNodeInfo)this.targetNode.getParent()).removeTypeAnnotation();
                break;
            }
            case 133: {
                this.targetNode.insertSiblings(this.content, false, this.inheritNamespaces);
                if (!affectsType) break;
                ((MutableNodeInfo)this.targetNode.getParent()).removeTypeAnnotation();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown insert position " + this.position);
            }
        }
        affectedRootSet.add((MutableNodeInfo)this.targetNode.getRoot());
    }

    @Override
    public NodeInfo getTargetNode() {
        return this.targetNode;
    }

    @Override
    public int getApplyPhase() {
        return this.position == 135 ? 1 : 2;
    }
}

