/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.xom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Durability;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.option.xom.XOMNodeWrapper;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;

public class XOMDocumentWrapper
extends XOMNodeWrapper
implements TreeInfo {
    protected Configuration config;
    protected long documentNumber;
    private HashMap<String, NodeInfo> idIndex;
    private SpaceStrippingRule spaceStrippingRule = NoElementsSpaceStrippingRule.getInstance();
    private HashMap<String, Object> userData;

    public XOMDocumentWrapper(Node root, Configuration config) {
        super(root, null, 0);
        config.requireProfessionalLicense("XOM");
        if (root.getParent() != null) {
            throw new IllegalArgumentException("root node must not have a parent node");
        }
        this.docWrapper = this;
        this.treeInfo = this;
        this.setConfiguration(config);
    }

    @Override
    public NodeInfo getRootNode() {
        return this;
    }

    public NodeInfo wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        return this.makeWrapper(node, this);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    @Override
    public void setSystemId(String uri) {
        ((Document)this.node).setBaseURI(uri);
    }

    @Override
    public long getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public Durability getDurability() {
        return Durability.LASTING;
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        if (this.idIndex == null) {
            Element elem;
            switch (this.nodeKind) {
                case 9: {
                    elem = ((Document)this.node).getRootElement();
                    break;
                }
                case 1: {
                    elem = (Element)this.node;
                    break;
                }
                default: {
                    return null;
                }
            }
            this.idIndex = new HashMap(50);
            this.buildIDIndex(elem);
        }
        return this.idIndex.get(id);
    }

    private void buildIDIndex(Element elem) {
        int i = elem.getChildCount();
        while (--i >= 0) {
            Node child = elem.getChild(i);
            if (!(child instanceof Element)) continue;
            this.buildIDIndex((Element)child);
        }
        i = elem.getAttributeCount();
        while (--i >= 0) {
            Attribute att = elem.getAttribute(i);
            if (att.getType() != Attribute.Type.ID) continue;
            this.idIndex.put(att.getValue(), this.wrap((Node)elem));
        }
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        return Collections.emptyIterator();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        return null;
    }

    @Override
    public void setSpaceStrippingRule(SpaceStrippingRule rule) {
        this.spaceStrippingRule = rule;
    }

    @Override
    public SpaceStrippingRule getSpaceStrippingRule() {
        return this.spaceStrippingRule;
    }

    @Override
    public void setUserData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap(4);
        }
        if (value == null) {
            this.userData.remove(key);
        } else {
            this.userData.put(key, value);
        }
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }
}

