/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.UserSimpleType;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class PatternFacet
extends Facet {
    private final Configuration config;
    private UnicodeString requiredValue;
    private RegularExpression regex;
    private String flags = "";
    private boolean noMerge;

    public PatternFacet(Configuration config) {
        this.config = config;
    }

    @Override
    public String getName() {
        return "pattern";
    }

    @Override
    public UnicodeString getValue() {
        return this.requiredValue;
    }

    public RegularExpression getRegularExpression() {
        return this.regex;
    }

    public void setValue(String value) {
        this.requiredValue = StringView.of(value).tidy();
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    public String getFlags() {
        return this.flags;
    }

    public void compile(List<String> warnings) throws SchemaException {
        try {
            String lang = this.config.getXsdVersion() == 11 ? "XSD11" : "XSD10";
            this.regex = this.config.compileRegularExpression(this.requiredValue, this.flags, lang, warnings);
        }
        catch (XPathException e) {
            throw new SchemaException(e.getMessage());
        }
    }

    public void setDoNotMerge(boolean dont) {
        this.noMerge = dont;
    }

    public boolean isDoNotMerge() {
        return this.noMerge;
    }

    public void addBranch(UnicodeString pat) {
        try {
            this.setValue('(' + this.getValue().toString() + ")|(" + pat + ')');
            this.compile(null);
        }
        catch (SchemaException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) {
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        return this.regex.matches(value.getCanonicalLexicalRepresentation());
    }

    @Override
    public FunctionItem getFacetAsFunctionItem() {
        PatternFacet facet = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue(this.getName());
                }
                case "implementation": {
                    return new ObjectValue<PatternFacet>(facet);
                }
                case "value": {
                    return new StringValue(this.requiredValue);
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

