/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Trace;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;

public class TraceStreamer
extends TransmissionAdjunct
implements FeedMaker {
    public static int sequenceNr = 0;

    @Override
    public FeedMaker getFeedMaker(int arg) throws XPathException {
        return arg == 0 ? this : super.getFeedMaker(arg);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new TraceFeed((SystemFunctionCall)this.getExpression(), out, context);
    }

    private static class TraceFeed
    extends ItemFeed {
        String label;
        String seq = "trace " + sequenceNr++ + ": ";
        Stack<FleetingParentNode> stack = new Stack();

        public TraceFeed(SystemFunctionCall exp, ItemFeed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Trace function = (Trace)fnc.getTargetFunction();
            this.label = fnc.getArg(1).evaluateItem(this.getContext()).getStringValue();
            this.emit("open", null);
        }

        @Override
        public void append(Item item) throws XPathException {
            this.emit("item", item);
            this.getNextOutputter().append(item);
        }

        @Override
        public void close() throws XPathException {
            this.emit("close", null);
            this.getNextOutputter().close();
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            if (node.getNodeKind() == 9) {
                this.emit("startDocument", node);
            } else {
                this.emit("startElement", node);
            }
            this.stack.push(node);
            return this.getResultFeed().startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            FleetingParentNode node = this.stack.pop();
            if (node.getNodeKind() == 9) {
                this.emit("endDocument", node);
            } else {
                this.emit("endElement", node);
            }
            this.getResultFeed().endSelectedParentNode(locationId);
        }

        private void emit(String phase, Item val) {
            String message = this.seq + this.label + ": " + phase;
            Controller controller = this.getContext().getController();
            if (controller.isTracing()) {
                SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
                Trace function = (Trace)fnc.getTargetFunction();
                function.notifyListener(message, val, this.getContext());
            } else {
                Logger out = controller.getTraceFunctionDestination();
                if (out != null) {
                    Trace.traceItem(val, message, out);
                }
            }
        }
    }
}

