/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.om;

import com.saxonica.ee.stream.om.FleetingDocumentNode;
import com.saxonica.ee.stream.om.FleetingElementNode;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodePredicate;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;

public class FleetingNode
implements NodeInfo {
    private FleetingNode parent;
    protected FleetingDocumentNode root;
    private int nodeKind;
    private NodeName nodeName;
    private SchemaType typeAnnotation;
    private UnicodeString stringValue;
    private int nodeNumber;

    @Override
    public NodeInfo head() {
        return this;
    }

    @Override
    public TreeInfo getTreeInfo() {
        return this.root;
    }

    public int getDepth() {
        return this.parent == null ? 0 : this.parent.getDepth() + 1;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public void setParent(FleetingNode parent) {
        this.parent = parent;
        this.root = parent.root;
        this.nodeNumber = this.root.allocateNodeNumber();
    }

    public void setNodeName(NodeName name) {
        this.nodeName = name;
    }

    public void setNodeKind(int nodeKind) {
        this.nodeKind = nodeKind;
    }

    public void setStringValue(UnicodeString stringValue) {
        this.stringValue = stringValue;
    }

    public void setTypeAnnotation(SchemaType typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
    }

    @Override
    public final int getNodeKind() {
        return this.nodeKind;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FleetingNode) {
            FleetingNode fn = (FleetingNode)other;
            switch (this.getNodeKind()) {
                case 2: {
                    return this.getNodeKind() == fn.getNodeKind() && this.getParent() == fn.getParent() && this.getNodeName().equals(fn.getNodeName());
                }
                case 13: {
                    return this.getNodeKind() == fn.getNodeKind() && this.getParent() == fn.getParent() && this.getLocalPart().equals(fn.getLocalPart());
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        switch (this.getNodeKind()) {
            case 2: 
            case 13: {
                return this.getParent().hashCode() ^ this.getLocalPart().hashCode();
            }
        }
        return super.hashCode();
    }

    @Override
    public String getSystemId() {
        return this.root.getSystemId();
    }

    @Override
    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    @Override
    public final int compareOrder(NodeInfo other) {
        if (this.equals(other)) {
            return 0;
        }
        switch (this.getNodeKind()) {
            case 9: {
                return -1;
            }
            case 1: {
                if (other.getNodeKind() == 2 || other.getNodeKind() == 13) {
                    if (this.equals(other.getParent())) {
                        return -1;
                    }
                    return this.compareOrder(other.getParent());
                }
                return Integer.compare(this.getNodeNumber(), ((FleetingNode)other).getNodeNumber());
            }
            case 3: 
            case 7: 
            case 8: {
                if (other.getNodeKind() == 2 || other.getNodeKind() == 13) {
                    return this.compareOrder(other.getParent());
                }
                return Integer.compare(this.getNodeNumber(), ((FleetingNode)other).getNodeNumber());
            }
            case 2: {
                if (other.getNodeKind() == 2) {
                    if (this.getParent().equals(other.getParent())) {
                        return ((FleetingElementNode)this.getParent()).compareAttributeOrder(NameOfNode.makeName(this), NameOfNode.makeName(other));
                    }
                    return this.getParent().compareOrder(other.getParent());
                }
                if (other.getNodeKind() == 13) {
                    if (this.getParent().equals(other.getParent())) {
                        return 1;
                    }
                    return this.getParent().compareOrder(other.getParent());
                }
                if (other.equals(this.getParent())) {
                    return 1;
                }
                return this.getParent().compareOrder(other);
            }
            case 13: {
                if (other.getNodeKind() == 13) {
                    if (this.getParent().equals(other.getParent())) {
                        int i1;
                        int i0 = ((FleetingElementNode)this.getParent()).getNamespaceNodeIndex(this.getLocalPart());
                        return i0 < (i1 = ((FleetingElementNode)this.getParent()).getNamespaceNodeIndex(other.getLocalPart())) ? -1 : 1;
                    }
                    return this.getParent().compareOrder(other.getParent());
                }
                if (other.getNodeKind() == 2) {
                    if (this.getParent().equals(other.getParent())) {
                        return -1;
                    }
                    return this.getParent().compareOrder(other.getParent());
                }
                if (other.equals(this.getParent())) {
                    return 1;
                }
                return this.getParent().compareOrder(other);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final UnicodeString getUnicodeStringValue() {
        if (this.stringValue == null) {
            throw new UnsupportedOperationException("The string value of a streamed node is not available");
        }
        return this.stringValue;
    }

    @Override
    public boolean hasFingerprint() {
        return true;
    }

    @Override
    public final int getFingerprint() {
        if (this.nodeName == null) {
            return -1;
        }
        return this.nodeName.obtainFingerprint(this.getNamePool());
    }

    public final NodeName getNodeName() {
        return this.nodeName;
    }

    @Override
    public final String getLocalPart() {
        return this.nodeName == null ? "" : this.nodeName.getLocalPart();
    }

    @Override
    public final NamespaceUri getNamespaceUri() {
        return this.nodeName == null ? NamespaceUri.NULL : this.nodeName.getNamespaceUri();
    }

    @Override
    public final String getDisplayName() {
        return this.nodeName == null ? "" : this.nodeName.getDisplayName();
    }

    @Override
    public final String getPrefix() {
        return this.nodeName == null ? "" : this.nodeName.getPrefix();
    }

    @Override
    public Configuration getConfiguration() {
        return this.root.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.root.getNamePool();
    }

    @Override
    public final SchemaType getSchemaType() {
        return this.typeAnnotation;
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        return this.typeAnnotation.atomize(this);
    }

    @Override
    public final NodeInfo getParent() {
        return this.parent;
    }

    @Override
    public AxisIterator iterateAxis(int axisNumber, NodePredicate nodeTest) {
        if (AxisInfo.isAlwaysEmpty(axisNumber, this.nodeKind)) {
            return EmptyIterator.ofNodes();
        }
        switch (axisNumber) {
            case 0: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.ofNodes();
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, false), nodeTest);
            }
            case 1: {
                if (this.nodeKind == 9) {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                return new Navigator.AxisFilter(new Navigator.AncestorEnumeration(this, true), nodeTest);
            }
            case 9: {
                return Navigator.filteredSingleton(this.getParent(), nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 2: {
                return EmptyIterator.ofNodes();
            }
            case 8: {
                return EmptyIterator.ofNodes();
            }
        }
        XPathException err = new XPathException("Navigation using " + AxisInfo.axisName[axisNumber] + " axis is not supported from a streamed input node", "SXST0061");
        throw new UnsupportedOperationException(err);
    }

    @Override
    public String getAttributeValue(NamespaceUri uri, String local) {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this.root;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public void generateId(StringBuilder buffer) {
        switch (this.getNodeKind()) {
            case 2: {
                this.getParent().generateId(buffer);
                buffer.append('a').append(((FleetingElementNode)this.getParent()).getAttributeIndex(this.getNamespaceUri(), this.getLocalPart()));
                break;
            }
            case 13: {
                this.getParent().generateId(buffer);
                buffer.append('n').append(((FleetingElementNode)this.getParent()).getNamespaceNodeIndex(this.getLocalPart()));
                break;
            }
            case 9: {
                buffer.append("s").append(Math.abs(this.getTreeInfo().getDocumentNumber()));
                break;
            }
            default: {
                buffer.append("s").append(Math.abs(this.getTreeInfo().getDocumentNumber())).append("f").append(this.nodeNumber);
            }
        }
    }

    public NamespaceMap getInScopeNamespaces() {
        return null;
    }

    @Override
    public boolean isStreamed() {
        return true;
    }

    @Override
    public void setSystemId(String systemId) {
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamespaceMap getAllNamespaces() {
        return null;
    }
}

