/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.validate.ValidatingFilter;
import com.saxonica.ee.validate.ValidationStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.InvalidityHandler;
import net.sf.saxon.lib.InvalidityHandlerWrappingErrorReporter;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.BooleanValue;

public class XSIAttributeHandler
extends ValidatingFilter {
    private final HashSet<NamespaceUri> namespacesEncountered;
    private final HashMap<NamespaceUri, URI> schemaDocumentsRead;
    private boolean useXsiSchemaLocation;
    private final List<ValidationFailure> xsiValidationErrors = new ArrayList<ValidationFailure>(4);

    public XSIAttributeHandler(ValidationStack out) {
        super(out);
        this.namespacesEncountered = new HashSet(10);
        this.schemaDocumentsRead = new HashMap(10);
        this.useXsiSchemaLocation = this.getPipelineConfiguration().getParseOptions().isUseXsiSchemaLocation();
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.useXsiSchemaLocation = pipe.getParseOptions().isUseXsiSchemaLocation();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        boolean nilled = false;
        this.xsiValidationErrors.clear();
        SchemaType xsiType = null;
        boolean hasXsiAttributes = false;
        for (AttributeInfo att : attributes) {
            if (!att.getNodeName().hasURI(NamespaceUri.SCHEMA_INSTANCE)) continue;
            hasXsiAttributes = true;
            break;
        }
        AttributeMap attMap2 = attributes;
        if (hasXsiAttributes) {
            String xsiTypeValue = null;
            ArrayList<AttributeInfo> list = new ArrayList<AttributeInfo>(attributes.size());
            for (AttributeInfo att : attributes) {
                NodeName attName = att.getNodeName();
                SimpleType attType = att.getType();
                if (attName.hasURI(NamespaceUri.SCHEMA_INSTANCE)) {
                    String value = att.getValue();
                    int fp = attName.obtainFingerprint(this.getNamePool());
                    if (fp == 644) {
                        attType = BuiltInAtomicType.ANY_URI;
                        if (this.useXsiSchemaLocation) {
                            this.processXsiNoNamespaceSchemaLocation(value, location);
                        }
                    } else if (fp == 643) {
                        attType = BuiltInListType.ANY_URIS;
                        if (this.useXsiSchemaLocation) {
                            this.processXsiSchemaLocation(value, location);
                        }
                    } else if (fp == 641) {
                        attType = BuiltInAtomicType.QNAME;
                        xsiTypeValue = value;
                    } else if (fp == 642) {
                        attType = BuiltInAtomicType.BOOLEAN;
                        nilled = this.processXsiNil(value);
                    }
                    list.add(new AttributeInfo(att.getNodeName(), attType, att.getValue(), att.getLocation(), att.getProperties()));
                    continue;
                }
                list.add(att);
            }
            if (xsiTypeValue != null) {
                xsiType = this.processXsiType(xsiTypeValue, namespaces);
            }
            attMap2 = SequenceTool.attributeMapFromList(list);
        }
        if (this.nextReceiver instanceof ValidationStack) {
            ((ValidationStack)this.nextReceiver).setValidationContext(this.getValidationContext());
            ((ValidationStack)this.nextReceiver).setIsNilled(nilled);
            ((ValidationStack)this.nextReceiver).setXsiValidationErrors(this.xsiValidationErrors);
        }
        this.namespacesEncountered.add(elemName.getNamespaceUri());
        for (AttributeInfo att : attributes) {
            NamespaceUri uri = att.getNodeName().getNamespaceUri();
            this.namespacesEncountered.add(uri);
        }
        this.getValidationContext().setXSIType(xsiType);
        this.nextReceiver.startElement(elemName, type, attMap2, namespaces, location, properties);
    }

    private void processXsiSchemaLocation(String value, Location locationId) throws XPathException {
        String tok;
        StringTokenizer tokenizer = new StringTokenizer(value, " \t\n\r", false);
        NamespaceUri targetNS = null;
        while (tokenizer.hasMoreTokens()) {
            boolean ignore;
            tok = tokenizer.nextToken();
            if (targetNS == null) {
                targetNS = NamespaceUri.of(tok);
                continue;
            }
            URI absoluteLocation = null;
            try {
                absoluteLocation = ResolveURI.makeAbsolute(tok, locationId.getSystemId());
                ignore = absoluteLocation.equals(this.schemaDocumentsRead.get(targetNS));
                this.schemaDocumentsRead.put(targetNS, absoluteLocation);
            }
            catch (URISyntaxException err) {
                ignore = false;
            }
            if (!ignore) {
                if (this.namespacesEncountered.contains(targetNS) && this.getConfiguration().getXsdVersion() != 11) {
                    String message = "xsi:schemaLocation namespace " + Err.wrap(targetNS.toUnicodeString()) + " has already appeared earlier in the instance document";
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "schema-loc", "4");
                    this.reportValidationError(ve, false, locationId);
                }
                this.loadSchema(absoluteLocation, targetNS);
            }
            targetNS = null;
        }
        if (targetNS != null) {
            String message = "xsi:schemaLocation must contain an even number of URIs";
            ValidationFailure ve = new ValidationFailure(message);
            this.reportValidationError(ve, false, locationId);
        }
        tokenizer = new StringTokenizer(value, " \t\n\r", false);
        targetNS = null;
        while (tokenizer.hasMoreTokens()) {
            tok = tokenizer.nextToken();
            if (targetNS == null) {
                targetNS = NamespaceUri.of(tok);
                continue;
            }
            this.getConfiguration().sealNamespace(targetNS);
            targetNS = null;
        }
    }

    private void processXsiNoNamespaceSchemaLocation(String value, Location locationId) throws XPathException {
        boolean ignore;
        URI absoluteLocation = null;
        try {
            absoluteLocation = ResolveURI.makeAbsolute(value, locationId.getSystemId());
            ignore = absoluteLocation.equals(this.schemaDocumentsRead.get(NamespaceUri.NULL));
            this.schemaDocumentsRead.put(NamespaceUri.NULL, absoluteLocation);
        }
        catch (URISyntaxException err) {
            ignore = false;
        }
        if (!ignore) {
            if (this.namespacesEncountered.contains(NamespaceUri.NULL)) {
                String message = "xsi:noNamespaceSchemaLocation cannot appear after the first no-namespace element or attribute";
                ValidationFailure ve = new ValidationFailure(message);
                ve.setConstraintReference(1, "schema-loc", "4");
                this.reportValidationError(ve, false, locationId);
            }
            this.loadSchema(absoluteLocation, NamespaceUri.NULL);
        }
    }

    private boolean processXsiNil(String value) {
        ConversionResult v = StringConverter.StringToBoolean.INSTANCE.convertString(StringView.of(value).tidy());
        if (v instanceof ValidationFailure) {
            String message = "The value of xsi:nil must be a boolean";
            ValidationFailure ve = new ValidationFailure(message);
            this.xsiValidationErrors.add(ve);
        }
        return v == BooleanValue.TRUE;
    }

    private SchemaType processXsiType(String value, NamespaceResolver nsResolver) {
        block4: {
            Configuration config = this.getConfiguration();
            try {
                StructuredQName qName = StructuredQName.fromLexicalQName(value, true, false, nsResolver);
                SchemaType type = config.getSchemaType(qName);
                if (type == null) {
                    String message = "Unknown type " + Err.wrap(value) + " specified in xsi:type attribute";
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-elt", "4.2");
                    this.xsiValidationErrors.add(ve);
                    break block4;
                }
                if (type instanceof ComplexType && ((ComplexType)type).isAbstract()) {
                    String message = "Type " + Err.wrap(value) + " specified in xsi:type attribute is abstract";
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-type", "2");
                    this.xsiValidationErrors.add(ve);
                    break block4;
                }
                return type;
            }
            catch (XPathException de) {
                String message = "Invalid QName " + Err.wrap(value) + " specified in xsi:type attribute: " + de.getMessage();
                ValidationFailure ve = new ValidationFailure(message);
                ve.setConstraintReference(1, "cvc-elt", "4.1");
                this.xsiValidationErrors.add(ve);
            }
        }
        return null;
    }

    @Override
    public void endDocument() throws XPathException {
        super.endDocument();
        this.reportIfInvalid();
    }

    private void loadSchema(URI value, NamespaceUri targetNS) throws XPathException {
        int status = ((EnterpriseConfiguration)this.getConfiguration()).getNamespaceStatus(targetNS);
        if (status != 1 && status != 2) {
            return;
        }
        try {
            PipelineConfiguration pipe = new PipelineConfiguration(this.getPipelineConfiguration());
            InvalidityHandler handler = this.getValidationContext().getInvalidityHandler();
            if (handler instanceof InvalidityHandlerWrappingErrorReporter) {
                ErrorReporter listener = ((InvalidityHandlerWrappingErrorReporter)handler).getErrorReporter();
                pipe.setErrorReporter(listener);
            }
            EnterpriseConfiguration config = (EnterpriseConfiguration)pipe.getConfiguration();
            config.readSchema(pipe, null, value.toString(), targetNS);
        }
        catch (SchemaException e) {
            try {
                PipelineConfiguration pipe = new PipelineConfiguration(this.getPipelineConfiguration());
                EnterpriseConfiguration config = (EnterpriseConfiguration)pipe.getConfiguration();
                SchemaCompiler compiler = config.newSchemaCompiler();
                compiler.setPreparedSchema(config.getSuperSchema());
                config.getSuperSchema().validate(compiler);
                ErrorReporter reporter = pipe.getErrorReporter();
                reporter.report(new XmlProcessingException(e).asWarning());
                reporter.report(new XmlProcessingIncident("Validation will continue without the schema at " + value).asWarning());
            }
            catch (SchemaException err) {
                throw XPathException.makeXPathException(e);
            }
        }
    }
}

