/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.query.InputStreamMarker;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.CatalogCollection;
import net.sf.saxon.resource.EncodingDetector;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class UnparsedTextResource
implements Resource {
    private final Configuration config;
    private String contentType;
    private String encoding;
    private final String href;
    private String unparsedText = null;
    public static final ResourceFactory FACTORY = (context, details) -> new UnparsedTextResource(context, details);

    private UnparsedTextResource(XPathContext context, AbstractResourceCollection.InputDetails details) throws XPathException {
        this.config = context != null ? context.getConfiguration() : null;
        this.href = details.resourceUri;
        this.contentType = details.contentType;
        this.encoding = details.encoding;
        if (details.characterContent != null) {
            this.unparsedText = details.characterContent;
        } else if (details.binaryContent != null) {
            if (details.encoding == null) {
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(details.binaryContent);
                    details.encoding = EncodingDetector.inferStreamEncoding(is, "UTF-8", null);
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    throw new XPathException(e);
                }
            }
            this.unparsedText = this.makeString(details.binaryContent, details.encoding);
        }
    }

    public UnparsedTextResource(String uri, String content) {
        this.config = null;
        this.href = uri;
        this.unparsedText = content;
    }

    private String makeString(byte[] bytes, String encoding) throws XPathException {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new XPathException(e);
        }
    }

    @Override
    public String getResourceURI() {
        return this.href;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getContent() throws XPathException {
        if (this.unparsedText == null) {
            try {
                InputStream stream = ResourceLoader.urlStream(this.config, this.href);
                String enc = this.encoding;
                if (enc == null) {
                    stream = InputStreamMarker.ensureMarkSupported(stream);
                    enc = EncodingDetector.inferStreamEncoding(stream, "UTF-8", null);
                }
                this.unparsedText = CatalogCollection.makeStringFromStream(stream, enc);
            }
            catch (IOException e) {
                throw new XPathException(e);
            }
        }
        return this.unparsedText;
    }

    @Override
    public Item getItem() throws XPathException {
        return new StringValue(this.getContent());
    }

    @Override
    public String getContentType() {
        return this.contentType == null ? "text/plain" : this.contentType;
    }
}

