/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanDistanceQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.DistanceSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.util.Bits;

public abstract class OrderedDistanceSpans
extends DistanceSpans {
    protected boolean hasMoreFirstSpans;
    protected int minDistance;
    protected int maxDistance;
    protected List<CandidateSpan> candidateList;
    protected int candidateListIndex;
    protected int candidateListDocNum;

    public OrderedDistanceSpans(SpanDistanceQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
        this.minDistance = query.getMinDistance();
        this.maxDistance = query.getMaxDistance();
        this.hasMoreFirstSpans = this.firstSpans.next();
        this.candidateList = new ArrayList<CandidateSpan>();
        this.candidateListIndex = -1;
        if (this.hasMoreFirstSpans) {
            this.candidateListDocNum = this.firstSpans.doc();
        }
    }

    @Override
    protected boolean advance() throws IOException {
        while (this.hasMoreSpans && this.candidateListIndex < this.candidateList.size()) {
            ++this.candidateListIndex;
            while (this.candidateListIndex < this.candidateList.size()) {
                if (this.findMatch()) {
                    return true;
                }
                ++this.candidateListIndex;
            }
            do {
                this.hasMoreSpans = this.secondSpans.next();
                this.setCandidateList();
            } while (this.hasMoreSpans && !this.isSecondSpanValid());
        }
        return false;
    }

    protected abstract boolean isSecondSpanValid() throws IOException;

    protected abstract void setCandidateList() throws IOException;

    protected abstract boolean findMatch() throws IOException;

    protected void setMatchProperties(CandidateSpan candidateSpan, boolean isDistanceZero) throws IOException {
        this.setMatchFirstSpan(candidateSpan);
        this.setMatchSecondSpan(new CandidateSpan(this.secondSpans));
        if (isDistanceZero) {
            this.matchStartPosition = Math.min(candidateSpan.getStart(), this.secondSpans.start());
            this.matchEndPosition = Math.max(candidateSpan.getEnd(), this.secondSpans.end());
        } else {
            this.matchStartPosition = candidateSpan.getStart();
            this.matchEndPosition = this.secondSpans.end();
        }
        this.matchDocNumber = this.secondSpans.doc();
        if (this.collectPayloads) {
            if (candidateSpan.getPayloads() != null) {
                this.matchPayload.addAll(candidateSpan.getPayloads());
            }
            if (this.secondSpans.isPayloadAvailable()) {
                this.matchPayload.addAll(this.secondSpans.getPayload());
            }
        }
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.secondSpans.doc() < target && !this.secondSpans.skipTo(target)) {
            this.candidateList.clear();
            return false;
        }
        this.setCandidateList();
        this.matchPayload.clear();
        this.isStartEnumeration = false;
        return this.advance();
    }
}

