/*
 * Decompiled with CFR 0.152.
 */
package experimental.morfessor;

import experimental.morfessor.Vocab;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import marmot.util.Counter;
import marmot.util.FileUtils;

public class CharEncoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char UNKNOWN_ = '?';
    private Map<Character, Character> encode_map_;
    private Map<Character, Character> decode_map_;

    public CharEncoder(Map<Character, Character> encode_map) {
        this.encode_map_ = encode_map;
        this.decode_map_ = new HashMap<Character, Character>();
        for (Map.Entry<Character, Character> entry : encode_map.entrySet()) {
            this.decode_map_.put(entry.getValue(), entry.getKey());
        }
    }

    public static CharEncoder loadFromFile(String filename) {
        HashMap<Character, Character> encode_map = new HashMap<Character, Character>();
        try {
            BufferedReader reader = FileUtils.openFile(filename);
            while (reader.ready()) {
                String line = reader.readLine().trim();
                if (line.isEmpty()) continue;
                char key = line.charAt(0);
                char value = line.charAt(2);
                encode_map.put(Character.valueOf(key), Character.valueOf(value));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new CharEncoder(encode_map);
    }

    public static CharEncoder fromVocab(Vocab vocab) {
        int index;
        int length = 62;
        char[] alphabet = new char[length];
        int current = 0;
        for (index = 97; index <= 122; index = (int)((char)(index + 1))) {
            alphabet[current++] = index;
        }
        for (index = 65; index <= 90; index = (int)((char)(index + 1))) {
            alphabet[current++] = index;
        }
        for (index = 48; index <= 57; index = (int)((char)(index + 1))) {
            alphabet[current++] = index;
        }
        assert (length == current);
        Counter<Character> counter = new Counter<Character>();
        for (Map.Entry<String, Double> entry : vocab.entrySet()) {
            for (int index2 = 0; index2 < entry.getKey().length(); ++index2) {
                counter.increment(Character.valueOf(entry.getKey().charAt(index2)), entry.getValue());
            }
        }
        HashMap<Character, Character> encode_map = new HashMap<Character, Character>();
        current = length - 1;
        HashSet<Character> alphabet_set = new HashSet<Character>();
        for (char c : alphabet) {
            alphabet_set.add(Character.valueOf(c));
        }
        Object object = counter.sortedEntries().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            if (alphabet_set.isEmpty()) break;
            char c = ((Character)entry.getKey()).charValue();
            while (!alphabet_set.contains(Character.valueOf(c))) {
                c = alphabet[current--];
            }
            alphabet_set.remove(Character.valueOf(c));
            encode_map.put((Character)entry.getKey(), Character.valueOf(c));
        }
        return new CharEncoder(encode_map);
    }

    public String encode(String word) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < word.length(); ++index) {
            Character c = this.encode_map_.get(Character.valueOf(word.charAt(index)));
            if (c == null) {
                sb.append('?');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String decode(String word) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < word.length(); ++index) {
            Character c = this.decode_map_.get(Character.valueOf(word.charAt(index)));
            if (c == null) {
                sb.append('?');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

