/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.io.IOException;
import opennlp.tools.lemmatizer.LemmaSample;
import opennlp.tools.lemmatizer.LemmatizerContextGenerator;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.util.ObjectStream;

public class LemmaSampleSequenceStream
implements SequenceStream<LemmaSample> {
    private final ObjectStream<LemmaSample> samples;
    private final LemmatizerContextGenerator contextGenerator;

    public LemmaSampleSequenceStream(ObjectStream<LemmaSample> samples, LemmatizerContextGenerator contextGenerator) {
        this.samples = samples;
        this.contextGenerator = contextGenerator;
    }

    @Override
    public Sequence<LemmaSample> read() throws IOException {
        LemmaSample sample2 = this.samples.read();
        if (sample2 != null) {
            String[] sentence = sample2.getTokens();
            String[] tags = sample2.getTags();
            String[] preds = sample2.getLemmas();
            Event[] events = new Event[sentence.length];
            for (int i = 0; i < sentence.length; ++i) {
                CharSequence[] context = this.contextGenerator.getContext(i, sentence, tags, preds);
                events[i] = new Event(tags[i], context);
            }
            return new Sequence<LemmaSample>(events, sample2);
        }
        return null;
    }

    @Override
    public Event[] updateContext(Sequence<LemmaSample> sequence, AbstractModel model) {
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.samples.reset();
    }

    @Override
    public void close() throws IOException {
        this.samples.close();
    }
}

