/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.FieldOrSelector;
import com.saxonica.ee.schema.IdentityField;
import com.saxonica.ee.schema.IdentitySelector;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SelectionParser;
import com.saxonica.ee.stream.StreamingPatternMaker;
import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.Whitespace;

public class XSDFieldOrSelector
extends AnnotationParent {
    private FieldOrSelector fieldOrSelector = null;

    XSDFieldOrSelector() {
    }

    @Override
    protected void prepareAttributes() throws SchemaException {
        Pattern selector;
        Expression exp;
        String xpath;
        NamespaceUri defaultNS;
        boolean isField = this.getLocalPart().equals("field");
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"id", "xpath", "xpathDefaultNamespace"};
        this.allowAttributes(atts, allowed);
        String defaultNSstring = atts.getValue(NamespaceUri.NULL, "xpathDefaultNamespace");
        if (defaultNSstring == null) {
            defaultNSstring = this.getXSDSchema().getXPathDefaultNamespace();
        }
        if (defaultNSstring != null) {
            switch (defaultNSstring) {
                case "##defaultNamespace": {
                    defaultNS = this.getURIForPrefix("", true);
                    break;
                }
                case "##targetNamespace": {
                    defaultNS = this.getXSDSchema().getTargetNamespace();
                    break;
                }
                case "##local": {
                    defaultNS = NamespaceUri.NULL;
                    break;
                }
                default: {
                    defaultNS = NamespaceUri.of(defaultNSstring);
                    break;
                }
            }
        } else {
            defaultNS = NamespaceUri.NULL;
        }
        if ((xpath = atts.getValue(NamespaceUri.NULL, "xpath")) == null) {
            this.missingAttribute("xpath");
            xpath = ".";
        }
        SchemaElement.XPathStaticContext env = new SchemaElement.XPathStaticContext(this);
        env.setDefaultElementNamespace(defaultNS);
        env.setXPathLanguageLevel(20);
        try {
            exp = new XPathParser(env).parse(xpath, 0, 0, env);
            boolean allowExtensions = this.getXSDSchema().getAllowedExtensions().contains("id-xpath-syntax");
            if (allowExtensions) {
                ArrayList<String> reasonsForFailure = new ArrayList<String>();
                selector = StreamingPatternMaker.makeStreamingPattern(exp, this.getConfiguration(), reasonsForFailure);
                if (!reasonsForFailure.isEmpty()) {
                    throw new XPathException((String)reasonsForFailure.get(0));
                }
            } else {
                SelectionParser selectionParser = new SelectionParser(env);
                selector = selectionParser.parseSelector(xpath, env, isField);
                exp = selectionParser.getOptimizedExpression();
            }
            selector.setLocation(env.getContainingLocation());
            selector.setRetainedStaticContext(env.makeRetainedStaticContext());
        }
        catch (XPathException err) {
            this.error(err.getMessage());
            selector = new NodeTestPattern(ErrorType.getInstance());
            exp = Literal.makeEmptySequence();
        }
        this.processId();
        if (isField) {
            String order = Whitespace.trim(this.getAttributeValue(NamespaceUri.SAXON, "order"));
            boolean ascending = true;
            if (order != null) {
                switch (order) {
                    case "ascending": {
                        break;
                    }
                    case "descending": {
                        ascending = false;
                        break;
                    }
                    default: {
                        this.error("xs:field/@saxon:order must be 'ascending' or 'descending'");
                    }
                }
            }
            this.fieldOrSelector = new IdentityField(xpath);
            this.fieldOrSelector.setLocator(this);
            this.fieldOrSelector.setSelection(selector);
            this.fieldOrSelector.setSelectExpression(exp);
            this.fieldOrSelector.setNamespaceContext(this.makeNamespaceContext());
            this.fieldOrSelector.setXPathDefaultNamespace(defaultNS);
            ((IdentityField)this.fieldOrSelector).setAscending(ascending);
        } else {
            this.fieldOrSelector = new IdentitySelector(xpath);
            this.fieldOrSelector.setLocator(this);
            this.fieldOrSelector.setSelection(selector);
            this.fieldOrSelector.setSelectExpression(exp);
            this.fieldOrSelector.setNamespaceContext(this.makeNamespaceContext());
            this.fieldOrSelector.setXPathDefaultNamespace(defaultNS);
        }
    }

    IdentityField getIdentityField() {
        if (this.fieldOrSelector instanceof IdentityField) {
            return (IdentityField)this.fieldOrSelector;
        }
        return null;
    }

    IdentitySelector getIdentitySelector() {
        if (this.fieldOrSelector instanceof IdentitySelector) {
            return (IdentitySelector)this.fieldOrSelector;
        }
        return null;
    }
}

